/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentDiskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentDiskUtil.class);
    private static final String READ_ONLY = "r";
    private static final String READ_WRITE = "rw";
    private static final int RETRY_COUNT = 10;
    private static final int SLEEP_BASETIME = 10;

    public static String getFileContent(String path, String charsetName) throws IOException {
        File file = new File(path);
        return ConcurrentDiskUtil.getFileContent(file, charsetName);
    }

    /*
     * Exception decompiling
     */
    public static String getFileContent(File file, String charsetName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean writeFileContent(String path, String content, String charsetName) throws IOException {
        File file = new File(path);
        return ConcurrentDiskUtil.writeFileContent(file, content, charsetName);
    }

    public static Boolean writeFileContent(File file, String content, String charsetName) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            return false;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, READ_WRITE);
             FileChannel channel = raf.getChannel();
             FileLock lock = ConcurrentDiskUtil.tryLock(file, channel, false);){
            byte[] contentBytes = content.getBytes(charsetName);
            ByteBuffer sendBuffer = ByteBuffer.wrap(contentBytes);
            while (sendBuffer.hasRemaining()) {
                channel.write(sendBuffer);
            }
            channel.truncate(contentBytes.length);
        }
        catch (FileNotFoundException e) {
            throw new IOException("file not exist");
        }
        return true;
    }

    public static String byteBufferToString(ByteBuffer buffer, String charsetName) throws IOException {
        Charset charset = Charset.forName(charsetName);
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = decoder.decode(buffer.asReadOnlyBuffer());
        return charBuffer.toString();
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.warn("sleep wrong", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static FileLock tryLock(File file, FileChannel channel, boolean shared) throws IOException {
        FileLock result = null;
        int i = 0;
        do {
            try {
                result = channel.tryLock(0L, Long.MAX_VALUE, shared);
            }
            catch (Exception e) {
                if (++i > 10) {
                    LOGGER.error("[NA] lock " + file.getName() + " fail;retryed time: " + i, (Throwable)e);
                    throw new IOException("lock " + file.getAbsolutePath() + " conflict");
                }
                ConcurrentDiskUtil.sleep(10 * i);
                LOGGER.warn("lock " + file.getName() + " conflict;retry time: " + i);
            }
        } while (null == result);
        return result;
    }
}

