/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.address;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.AbstractServerListProvider;
import com.alibaba.nacos.client.address.ServerListChangeEvent;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class EndpointServerListProvider
extends AbstractServerListProvider {
    private static final Logger LOGGER = LogUtils.logger(EndpointServerListProvider.class);
    private NacosRestTemplate nacosRestTemplate;
    private static final String CUSTOM_NAME = "custom";
    private final long refreshServerListInternal = TimeUnit.SECONDS.toMillis(30L);
    private final int initServerListRetryTimes = 5;
    private long lastServerListRefreshTime = 0L;
    private ScheduledExecutorService refreshServerListExecutor;
    private String endpoint;
    private int endpointPort = 8080;
    private String endpointContextPath;
    private String serverListName = ParamUtil.getDefaultNodesPath();
    private volatile List<String> serversFromEndpoint = new ArrayList<String>();
    private String addressServerUrl;
    private String moduleName = "default";

    @Override
    public void init(NacosClientProperties properties, NacosRestTemplate nacosRestTemplate) throws NacosException {
        super.init(properties, nacosRestTemplate);
        this.nacosRestTemplate = nacosRestTemplate;
        this.initEndpoint(properties);
        this.initEndpointPort(properties);
        this.initEndpointContextPath(properties);
        this.initServerListName(properties);
        this.initAddressServerUrl(properties);
        this.initModuleName(properties);
        this.startRefreshServerListTask(properties);
    }

    @Override
    public List<String> getServerList() {
        return this.serversFromEndpoint;
    }

    @Override
    public String getServerName() {
        String contextPathTmp = StringUtils.isNotBlank((String)this.endpointContextPath) ? this.endpointContextPath : this.contextPath;
        return "custom-" + String.join((CharSequence)"_", this.endpoint, String.valueOf(this.endpointPort), contextPathTmp, this.serverListName) + (StringUtils.isNotBlank((String)this.namespace) ? "_" + StringUtils.trim((String)this.namespace) : "");
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    public boolean match(NacosClientProperties properties) {
        String endpointTmp = this.getEndPointTmp(properties);
        return StringUtils.isNotBlank((String)endpointTmp);
    }

    @Override
    public String getAddressSource() {
        return this.addressServerUrl;
    }

    private String getEndPointTmp(NacosClientProperties properties) {
        String endpointTmp = properties.getProperty("endpoint");
        String isUseEndpointRuleParsing = properties.getProperty("isUseEndpointParsingRule", properties.getProperty("nacos.use.endpoint.parsing.rule", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseEndpointRuleParsing)) {
            endpointTmp = ParamUtil.parsingEndpointRule(endpointTmp);
        }
        return endpointTmp;
    }

    public void startRefreshServerListTask(NacosClientProperties properties) throws NacosException {
        for (int i = 0; i < 5 && this.getServerList().isEmpty(); ++i) {
            this.refreshServerListIfNeed();
            if (!this.serversFromEndpoint.isEmpty()) break;
            try {
                this.wait((long)(i + 1) * 100L);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("get serverlist fail,url: {}", (Object)this.addressServerUrl);
            }
        }
        if (this.serversFromEndpoint.isEmpty()) {
            LOGGER.error("[init-serverlist] fail to get NACOS-server serverlist! url: {}", (Object)this.addressServerUrl);
            throw new NacosException(500, "fail to get NACOS-server serverlist! not connnect url:" + this.addressServerUrl);
        }
        this.refreshServerListExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.address.EndpointServerListProvider.refreshServerList"));
        long refreshInterval = Long.parseLong(properties.getProperty("endpointRefreshIntervalSeconds", "30"));
        this.refreshServerListExecutor.scheduleWithFixedDelay(this::refreshServerListIfNeed, 0L, refreshInterval, TimeUnit.SECONDS);
    }

    private void refreshServerListIfNeed() {
        try {
            if (System.currentTimeMillis() - this.lastServerListRefreshTime < this.refreshServerListInternal) {
                return;
            }
            List<String> list = this.getServerListFromEndpoint();
            if (CollectionUtils.isEmpty(list)) {
                throw new Exception("Can not acquire Nacos list");
            }
            list.sort(String::compareTo);
            if (!CollectionUtils.isEqualCollection(list, this.serversFromEndpoint)) {
                LOGGER.info("[SERVER-LIST] server list is updated: {}", list);
                this.serversFromEndpoint = list;
                this.lastServerListRefreshTime = System.currentTimeMillis();
                NotifyCenter.publishEvent((Event)new ServerListChangeEvent());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("failed to update server list", e);
        }
    }

    private List<String> getServerListFromEndpoint() {
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(this.addressServerUrl, HttpUtils.builderHeader((String)this.moduleName), Query.EMPTY, String.class);
            if (!httpResult.ok()) {
                LOGGER.error("[check-serverlist] error. addressServerUrl: {}, code: {}", (Object)this.addressServerUrl, (Object)httpResult.getCode());
                return null;
            }
            List lines = IoUtils.readLines((Reader)new StringReader((String)httpResult.getData()));
            ArrayList<String> result = new ArrayList<String>(lines.size());
            for (String serverAddr : lines) {
                String[] ipPort = InternetAddressUtil.splitIPPortStr((String)serverAddr);
                String ip = ipPort[0].trim();
                if (ipPort.length == 1) {
                    result.add(ip + ":" + ParamUtil.getDefaultServerPort());
                    continue;
                }
                result.add(serverAddr);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("[check-serverlist] exception. url: {}", (Object)this.addressServerUrl, (Object)e);
            return null;
        }
    }

    private void initEndpoint(NacosClientProperties properties) {
        this.endpoint = this.getEndPointTmp(properties);
    }

    private void initEndpointPort(NacosClientProperties properties) {
        String endpointPortTmp = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("ALIBABA_ALIWARE_ENDPOINT_PORT"), () -> properties.getProperty("endpointPort"));
        if (StringUtils.isNotBlank((String)endpointPortTmp)) {
            this.endpointPort = Integer.parseInt(endpointPortTmp);
        }
    }

    private void initEndpointContextPath(NacosClientProperties properties) {
        String endpointContextPathTmp = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("ALIBABA_ALIWARE_ENDPOINT_CONTEXT_PATH"), () -> properties.getProperty("endpointContextPath"));
        if (StringUtils.isNotBlank((String)endpointContextPathTmp)) {
            this.endpointContextPath = endpointContextPathTmp;
        }
    }

    private void initServerListName(NacosClientProperties properties) {
        String serverListNameTmp = properties.getProperty("endpointClusterName");
        boolean isUseClusterName = Boolean.parseBoolean(properties.getProperty("isAdaptClusterNameUsage"));
        if (StringUtils.isBlank((CharSequence)serverListNameTmp) && isUseClusterName) {
            serverListNameTmp = properties.getProperty("clusterName");
        }
        if (!StringUtils.isBlank((CharSequence)serverListNameTmp)) {
            this.serverListName = serverListNameTmp;
        }
    }

    private void initAddressServerUrl(NacosClientProperties properties) {
        String contextPathTmp = StringUtils.isNotBlank((String)this.endpointContextPath) ? ContextPathUtil.normalizeContextPath(this.endpointContextPath) : ContextPathUtil.normalizeContextPath(this.contextPath);
        StringBuilder addressServerUrlTem = new StringBuilder(String.format("http://%s:%d%s/%s", this.endpoint, this.endpointPort, contextPathTmp, this.serverListName));
        boolean hasQueryString = false;
        if (StringUtils.isNotBlank((String)this.namespace)) {
            addressServerUrlTem.append("?namespace=").append(this.namespace);
            hasQueryString = true;
        }
        if (properties.containsKey("endpointQueryParams")) {
            addressServerUrlTem.append(hasQueryString ? "&" : "?");
            addressServerUrlTem.append(properties.getProperty("endpointQueryParams"));
        }
        this.addressServerUrl = addressServerUrlTem.toString();
        LOGGER.info("address server url = {}", (Object)this.addressServerUrl);
    }

    private void initModuleName(NacosClientProperties properties) {
        String moduleNameTmp = properties.getProperty("clientModuleType");
        if (StringUtils.isNotBlank((String)moduleNameTmp)) {
            this.moduleName = moduleNameTmp;
        }
    }

    public void shutdown() throws NacosException {
        if (null != this.refreshServerListExecutor) {
            this.refreshServerListExecutor.shutdown();
        }
    }
}

