/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.address;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.ServerListProvider;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.List;

public abstract class AbstractServerListProvider
implements ServerListProvider {
    protected String contextPath = ParamUtil.getDefaultContextPath();
    protected String namespace = "";

    @Override
    public void init(NacosClientProperties properties, NacosRestTemplate nacosRestTemplate) throws NacosException {
        if (null == properties) {
            throw new NacosException(400, "properties is null");
        }
        this.initContextPath(properties);
        this.initNameSpace(properties);
    }

    @Override
    public abstract List<String> getServerList();

    @Override
    public abstract String getServerName();

    @Override
    public abstract int getOrder();

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    private void initContextPath(NacosClientProperties properties) {
        String contentPathTmp = properties.getProperty("contextPath");
        if (!StringUtils.isBlank((CharSequence)contentPathTmp)) {
            this.contextPath = contentPathTmp;
        }
    }

    private void initNameSpace(NacosClientProperties properties) {
        String namespace = properties.getProperty("namespace");
        if (StringUtils.isNotBlank((String)namespace)) {
            this.namespace = namespace;
        }
    }
}

