/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.selector;

import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.selector.NamingContext;
import com.alibaba.nacos.api.naming.selector.NamingResult;
import com.alibaba.nacos.api.naming.selector.NamingSelector;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.client.naming.event.InstancesDiff;
import com.alibaba.nacos.client.naming.listener.NamingChangeEvent;
import com.alibaba.nacos.client.naming.selector.NamingListenerInvoker;
import com.alibaba.nacos.client.selector.AbstractSelectorWrapper;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.Collections;
import java.util.List;

public class NamingSelectorWrapper
extends AbstractSelectorWrapper<NamingSelector, NamingEvent, InstancesChangeEvent> {
    private String serviceName;
    private String groupName;
    private String clusters;
    private final InnerNamingContext namingContext = new InnerNamingContext();

    public NamingSelectorWrapper(NamingSelector selector, EventListener listener) {
        super(selector, new NamingListenerInvoker(listener));
    }

    public NamingSelectorWrapper(String serviceName, String groupName, String clusters, NamingSelector selector, EventListener listener) {
        this(selector, listener);
        this.serviceName = serviceName;
        this.groupName = groupName;
        this.clusters = clusters;
    }

    @Override
    protected boolean isSelectable(InstancesChangeEvent event) {
        return event != null && event.getHosts() != null && event.getInstancesDiff() != null;
    }

    @Override
    public boolean isCallable(NamingEvent event) {
        if (event == null) {
            return false;
        }
        NamingChangeEvent changeEvent = (NamingChangeEvent)event;
        return changeEvent.isAdded() || changeEvent.isRemoved() || changeEvent.isModified();
    }

    @Override
    protected NamingEvent buildListenerEvent(InstancesChangeEvent event) {
        List<Instance> currentIns = Collections.emptyList();
        if (CollectionUtils.isNotEmpty(event.getHosts())) {
            currentIns = this.doSelect(event.getHosts());
        }
        InstancesDiff diff = event.getInstancesDiff();
        InstancesDiff newDiff = new InstancesDiff();
        if (diff.isAdded()) {
            newDiff.setAddedInstances(this.doSelect(diff.getAddedInstances()));
        }
        if (diff.isRemoved()) {
            newDiff.setRemovedInstances(this.doSelect(diff.getRemovedInstances()));
        }
        if (diff.isModified()) {
            newDiff.setModifiedInstances(this.doSelect(diff.getModifiedInstances()));
        }
        return new NamingChangeEvent(this.serviceName, this.groupName, this.clusters, currentIns, newDiff);
    }

    private List<Instance> doSelect(List<Instance> instances) {
        NamingContext context = this.getNamingContext(instances);
        return (List)((NamingResult)((NamingSelector)this.getSelector()).select((Object)context)).getResult();
    }

    private NamingContext getNamingContext(List<Instance> instances) {
        this.namingContext.setInstances(instances);
        return this.namingContext;
    }

    private class InnerNamingContext
    implements NamingContext {
        private List<Instance> instances;

        private InnerNamingContext() {
        }

        public String getServiceName() {
            return NamingSelectorWrapper.this.serviceName;
        }

        public String getGroupName() {
            return NamingSelectorWrapper.this.groupName;
        }

        public String getClusters() {
            return NamingSelectorWrapper.this.clusters;
        }

        public List<Instance> getInstances() {
            return this.instances;
        }

        private void setInstances(List<Instance> instances) {
            this.instances = instances;
        }
    }
}

