/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.auth.impl.process.HttpLoginProcessor;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.AbstractClientAuthService;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosClientAuthServiceImpl
extends AbstractClientAuthService {
    private static final Logger SECURITY_LOGGER = LoggerFactory.getLogger(NacosClientAuthServiceImpl.class);
    private long tokenTtl;
    private long lastRefreshTime;
    private long tokenRefreshWindow;
    private volatile LoginIdentityContext loginIdentityContext = new LoginIdentityContext();

    public Boolean login(Properties properties) {
        try {
            if (System.currentTimeMillis() - this.lastRefreshTime < TimeUnit.SECONDS.toMillis(this.tokenTtl - this.tokenRefreshWindow)) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)properties.getProperty("username"))) {
                this.lastRefreshTime = System.currentTimeMillis();
                return true;
            }
            for (String server : this.serverList) {
                HttpLoginProcessor httpLoginProcessor = new HttpLoginProcessor(this.nacosRestTemplate);
                properties.setProperty("server", server);
                LoginIdentityContext identityContext = httpLoginProcessor.getResponse(properties);
                if (identityContext == null) continue;
                if (identityContext.getAllKey().contains("accessToken")) {
                    this.tokenTtl = Long.parseLong(identityContext.getParameter("tokenTtl"));
                    this.tokenRefreshWindow = this.tokenTtl / 10L;
                    this.lastRefreshTime = System.currentTimeMillis();
                    LoginIdentityContext newCtx = new LoginIdentityContext();
                    newCtx.setParameter("accessToken", identityContext.getParameter("accessToken"));
                    this.loginIdentityContext = newCtx;
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            SECURITY_LOGGER.warn("[SecurityProxy] login failed, error: ", throwable);
            return false;
        }
        return false;
    }

    public LoginIdentityContext getLoginIdentityContext(RequestResource resource) {
        return this.loginIdentityContext;
    }

    public void shutdown() throws NacosException {
    }
}

