/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.parser.http;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.parser.http.AbstractHttpResourceParser;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Properties;

public class ConfigHttpResourceParser
extends AbstractHttpResourceParser {
    @Override
    protected String getNamespaceId(HttpServletRequest request) {
        String namespaceId = request.getParameter("namespaceId");
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = request.getParameter("tenant");
        }
        return NamespaceUtil.processNamespaceParameter((String)namespaceId);
    }

    @Override
    protected String getNamespaceId(HttpServletRequest request, Secured secured) {
        return Arrays.stream(secured.tags()).filter(tag -> tag.startsWith("namespaceId")).map(tag -> tag.split(":")).filter(splitTags -> ((String[])splitTags).length >= 2).map(splitTags -> request.getParameter(splitTags[1])).filter(StringUtils::isNotBlank).findFirst().orElseGet(() -> this.getNamespaceId(request));
    }

    @Override
    protected String getGroup(HttpServletRequest request) {
        String groupName = request.getParameter("groupName");
        if (StringUtils.isBlank((CharSequence)groupName)) {
            groupName = request.getParameter("group");
        }
        return StringUtils.isBlank((CharSequence)groupName) ? "" : groupName;
    }

    @Override
    protected String getResourceName(HttpServletRequest request) {
        String dataId = request.getParameter("dataId");
        return StringUtils.isBlank((CharSequence)dataId) ? "" : dataId;
    }

    @Override
    protected Properties getProperties(HttpServletRequest request) {
        return new Properties();
    }
}

