/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.parser.http;

import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.auth.parser.http.AbstractHttpResourceParser;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Properties;

public class AiHttpResourceParser
extends AbstractHttpResourceParser {
    public static final String MCP_PATH = "/ai/mcp";
    public static final String A2A_PATH = "/ai/a2a";
    private static final String AGENT_CARD_PARAM = "agentCard";

    @Override
    protected String getNamespaceId(HttpServletRequest request) {
        String namespaceId = request.getParameter("namespaceId");
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        return namespaceId;
    }

    @Override
    protected String getGroup(HttpServletRequest request) {
        return "DEFAULT_GROUP";
    }

    @Override
    protected String getResourceName(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (url.contains(MCP_PATH)) {
            return this.getMcpName(request);
        }
        if (url.contains(A2A_PATH)) {
            return this.getAgentName(request);
        }
        return "";
    }

    private String getMcpName(HttpServletRequest request) {
        String mcpName = request.getParameter("mcpName");
        return StringUtils.isBlank((CharSequence)mcpName) ? "" : mcpName;
    }

    private String getAgentName(HttpServletRequest request) {
        String agentName = request.getParameter("agentName");
        if (request.getParameterMap().containsKey(AGENT_CARD_PARAM)) {
            agentName = this.deserializeAndGetAgentName(request.getParameter(AGENT_CARD_PARAM));
        }
        return StringUtils.isBlank((CharSequence)agentName) ? "" : agentName;
    }

    private String deserializeAndGetAgentName(String agentCardJson) {
        try {
            AgentCard agentCard = (AgentCard)JacksonUtils.toObj((String)agentCardJson, AgentCard.class);
            return agentCard.getName();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    @Override
    protected Properties getProperties(HttpServletRequest request) {
        return new Properties();
    }
}

