/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.parser.grpc;

import com.alibaba.nacos.api.ai.remote.request.AbstractAgentRequest;
import com.alibaba.nacos.api.ai.remote.request.AbstractMcpRequest;
import com.alibaba.nacos.api.ai.remote.request.ReleaseAgentCardRequest;
import com.alibaba.nacos.api.ai.remote.request.ReleaseMcpServerRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.parser.grpc.AbstractGrpcResourceParser;
import com.alibaba.nacos.common.utils.StringUtils;

public class AiGrpcResourceParser
extends AbstractGrpcResourceParser {
    @Override
    protected String getNamespaceId(Request request) {
        String namespaceId = null;
        if (request instanceof AbstractMcpRequest) {
            namespaceId = ((AbstractMcpRequest)request).getNamespaceId();
        } else if (request instanceof AbstractAgentRequest) {
            namespaceId = ((AbstractAgentRequest)request).getNamespaceId();
        }
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        return namespaceId;
    }

    @Override
    protected String getGroup(Request request) {
        return "DEFAULT_GROUP";
    }

    @Override
    protected String getResourceName(Request request) {
        if (request instanceof AbstractMcpRequest) {
            return this.getMcpName((AbstractMcpRequest)request);
        }
        if (request instanceof AbstractAgentRequest) {
            return this.getAgentName((AbstractAgentRequest)request);
        }
        return "";
    }

    private String getMcpName(AbstractMcpRequest request) {
        ReleaseMcpServerRequest releaseMcpServerRequest;
        String mcpName = request.getMcpName();
        if (request instanceof ReleaseMcpServerRequest && null != (releaseMcpServerRequest = (ReleaseMcpServerRequest)request).getServerSpecification()) {
            mcpName = releaseMcpServerRequest.getServerSpecification().getName();
        }
        return StringUtils.isBlank((CharSequence)mcpName) ? "" : mcpName;
    }

    private String getAgentName(AbstractAgentRequest request) {
        ReleaseAgentCardRequest releaseAgentCardRequest;
        String agentName = request.getAgentName();
        if (request instanceof ReleaseAgentCardRequest && null != (releaseAgentCardRequest = (ReleaseAgentCardRequest)request).getAgentCard()) {
            agentName = releaseAgentCardRequest.getAgentCard().getName();
        }
        return StringUtils.isBlank((CharSequence)agentName) ? "" : agentName;
    }
}

