/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.parser;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.parser.ResourceParser;
import com.alibaba.nacos.plugin.auth.api.Resource;
import java.util.Properties;

public abstract class AbstractResourceParser<R>
implements ResourceParser<R> {
    @Override
    public Resource parse(R request, Secured secured) {
        String namespaceId = this.getNamespaceId(request, secured);
        String group = this.getGroup(request);
        String name = this.getResourceName(request);
        Properties properties = this.getProperties(request);
        String action = secured.action().toString();
        properties.putIfAbsent("action", action);
        this.injectTagsToProperties(properties, secured);
        return new Resource(namespaceId, group, name, secured.signType(), properties);
    }

    protected abstract String getNamespaceId(R var1);

    protected String getNamespaceId(R request, Secured secured) {
        return this.getNamespaceId(request);
    }

    protected abstract String getGroup(R var1);

    protected abstract String getResourceName(R var1);

    protected abstract Properties getProperties(R var1);

    protected void injectTagsToProperties(Properties properties, Secured secured) {
        for (String each : secured.tags()) {
            properties.put(each, each);
        }
    }
}

