/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.AbstractProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.context.GrpcIdentityContextBuilder;
import com.alibaba.nacos.auth.parser.grpc.AbstractGrpcResourceParser;
import com.alibaba.nacos.auth.parser.grpc.AiGrpcResourceParser;
import com.alibaba.nacos.auth.parser.grpc.ConfigGrpcResourceParser;
import com.alibaba.nacos.auth.parser.grpc.NamingGrpcResourceParser;
import com.alibaba.nacos.auth.serveridentity.ServerIdentity;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityResult;
import com.alibaba.nacos.auth.util.Loggers;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.HashMap;
import java.util.Map;

public class GrpcProtocolAuthService
extends AbstractProtocolAuthService<Request> {
    private final Map<String, AbstractGrpcResourceParser> resourceParserMap = new HashMap<String, AbstractGrpcResourceParser>(2);
    private final GrpcIdentityContextBuilder identityContextBuilder;

    public GrpcProtocolAuthService(NacosAuthConfig authConfig) {
        super(authConfig);
        this.identityContextBuilder = new GrpcIdentityContextBuilder(authConfig);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.resourceParserMap.put("naming", new NamingGrpcResourceParser());
        this.resourceParserMap.put("config", new ConfigGrpcResourceParser());
        this.resourceParserMap.put("ai", new AiGrpcResourceParser());
    }

    @Override
    public Resource parseResource(Request request, Secured secured) {
        if (StringUtils.isNotBlank((String)secured.resource())) {
            return this.parseSpecifiedResource(secured);
        }
        String type = secured.signType();
        AbstractGrpcResourceParser parser = this.resourceParserMap.get(type);
        if (parser == null) {
            Loggers.AUTH.warn("Can't find Grpc request resourceParser for type {}", (Object)type);
            return this.useSpecifiedParserToParse(secured, request);
        }
        return parser.parse(request, secured);
    }

    @Override
    public IdentityContext parseIdentity(Request request) {
        return this.identityContextBuilder.build(request);
    }

    @Override
    public ServerIdentityResult checkServerIdentity(Request request, Secured secured) {
        if (ApiType.INNER_API != secured.apiType()) {
            return ServerIdentityResult.noMatched();
        }
        return super.checkServerIdentity(request, secured);
    }

    @Override
    protected ServerIdentity parseServerIdentity(Request request) {
        String serverIdentityKey = this.authConfig.getServerIdentityKey();
        String serverIdentity = request.getHeader(serverIdentityKey);
        return new ServerIdentity(serverIdentityKey, serverIdentity);
    }
}

