/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth;

import com.alibaba.nacos.auth.ProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.auth.serveridentity.ServerIdentity;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityChecker;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityCheckerHolder;
import com.alibaba.nacos.auth.serveridentity.ServerIdentityResult;
import com.alibaba.nacos.auth.util.Loggers;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import java.util.Optional;
import java.util.Properties;

public abstract class AbstractProtocolAuthService<R>
implements ProtocolAuthService<R> {
    protected final AuthConfigs authConfigs;
    protected final ServerIdentityChecker checker;

    protected AbstractProtocolAuthService(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
        this.checker = ServerIdentityCheckerHolder.getInstance().getChecker();
    }

    @Override
    public void initialize() {
        this.checker.init(this.authConfigs);
    }

    @Override
    public boolean enableAuth(Secured secured) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (authPluginService.isPresent()) {
            return ((AuthPluginService)authPluginService.get()).enableAuth(secured.action(), secured.signType());
        }
        Loggers.AUTH.warn("Can't find auth plugin for type {}, please add plugin to classpath or set {} as false", (Object)this.authConfigs.getNacosAuthSystemType(), (Object)"nacos.core.auth.enabled");
        return false;
    }

    @Override
    public boolean validateIdentity(IdentityContext identityContext, Resource resource) throws AccessException {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (authPluginService.isPresent()) {
            return ((AuthPluginService)authPluginService.get()).validateIdentity(identityContext, resource);
        }
        return true;
    }

    @Override
    public boolean validateAuthority(IdentityContext identityContext, Permission permission) throws AccessException {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (authPluginService.isPresent()) {
            return ((AuthPluginService)authPluginService.get()).validateAuthority(identityContext, permission);
        }
        return true;
    }

    @Override
    public ServerIdentityResult checkServerIdentity(R request, Secured secured) {
        if (this.isInvalidServerIdentity()) {
            return ServerIdentityResult.fail("Invalid server identity key or value, Please make sure set `nacos.core.auth.server.identity.key` and `nacos.core.auth.server.identity.value`, or open `nacos.core.auth.enable.userAgentAuthWhite`");
        }
        ServerIdentity serverIdentity = this.parseServerIdentity(request);
        return this.checker.check(serverIdentity, secured);
    }

    private boolean isInvalidServerIdentity() {
        return StringUtils.isBlank((CharSequence)this.authConfigs.getServerIdentityKey()) || StringUtils.isBlank((CharSequence)this.authConfigs.getServerIdentityValue());
    }

    protected abstract ServerIdentity parseServerIdentity(R var1);

    protected Resource parseSpecifiedResource(Secured secured) {
        Properties properties = new Properties();
        for (String each : secured.tags()) {
            properties.put(each, each);
        }
        return new Resource(null, null, secured.resource(), "specified", properties);
    }

    protected Resource useSpecifiedParserToParse(Secured secured, R request) {
        try {
            return secured.parser().newInstance().parse(request, secured);
        }
        catch (Exception e) {
            Loggers.AUTH.error("Use specified resource parser {} parse resource failed.", (Object)secured.parser().getCanonicalName(), (Object)e);
            return Resource.EMPTY_RESOURCE;
        }
    }
}

