/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import java.util.Arrays;

public class McpConfigUtils {
    public static String formatServerVersionInfoDataId(String id) {
        return String.format("%s-mcp-versions.json", id);
    }

    public static String formatServerSpecInfoDataId(String id, String version) {
        return String.format("%s-%s-mcp-server.json", id, version);
    }

    public static String formatServerToolSpecDataId(String id, String version) {
        return String.format("%s-%s-mcp-tools.json", id, version);
    }

    public static String formatServerNameTagBlurSearchValue(String serverName) {
        return "mcpServerName=*" + serverName + "*";
    }

    public static String formatServerNameTagAccurateSearchValue(String serverName) {
        return "mcpServerName=" + serverName;
    }

    public static boolean isConfigFound(ConfigQueryChainResponse.ConfigQueryStatus status) {
        return ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_FORMAL.equals((Object)status);
    }

    public static boolean isConfigNotFound(ConfigQueryChainResponse.ConfigQueryStatus status) {
        return ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND.equals((Object)status);
    }

    public static String buildMcpServerVersionConfigTags(String serverName) {
        return StringUtils.join(Arrays.asList("nacos.internal.config=mcp", "mcpServerName=" + serverName), (String)",");
    }
}

