/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.utils;

import com.alibaba.nacos.ai.form.a2a.admin.AgentCardForm;
import com.alibaba.nacos.ai.utils.McpRequestUtil;
import com.alibaba.nacos.api.ai.model.a2a.AgentCapabilities;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.remote.request.AbstractAgentRequest;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentRequestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpRequestUtil.class);

    public static AgentCard parseAgentCard(AgentCardForm agentCardForm) throws NacosApiException {
        try {
            AgentCard result = (AgentCard)JacksonUtils.toObj((String)agentCardForm.getAgentCard(), (TypeReference)new TypeReference<AgentCard>(){});
            AgentRequestUtil.validateAgentCard(result);
            return result;
        }
        catch (NacosDeserializationException e) {
            LOGGER.error(String.format("Deserialize %s from %s failed, ", AgentCard.class.getSimpleName(), agentCardForm.getAgentCard()), (Throwable)e);
            throw new NacosApiException(400, ErrorCode.PARAMETER_VALIDATE_ERROR, "agentCard is invalid. Can't be parsed.");
        }
    }

    public static void validateAgentCard(AgentCard agentCard) throws NacosApiException {
        AgentRequestUtil.validateAgentCardField("name", agentCard.getName());
        AgentRequestUtil.validateAgentCardField("version", agentCard.getVersion());
        AgentRequestUtil.validateAgentCardField("protocolVersion", agentCard.getProtocolVersion());
        AgentRequestUtil.validateAgentCardField("preferredTransport", agentCard.getPreferredTransport());
        AgentRequestUtil.validateAgentCardField("url", agentCard.getUrl());
        if (null == agentCard.getDescription()) {
            agentCard.setDescription("");
        }
        if (null == agentCard.getCapabilities()) {
            agentCard.setCapabilities(new AgentCapabilities());
        }
        if (null == agentCard.getDefaultInputModes()) {
            agentCard.setDefaultInputModes(List.of());
        }
        if (null == agentCard.getDefaultOutputModes()) {
            agentCard.setDefaultOutputModes(List.of());
        }
        if (null == agentCard.getSkills()) {
            agentCard.setSkills(List.of());
        }
    }

    public static void fillNamespaceId(AbstractAgentRequest request) {
        if (StringUtils.isEmpty((String)request.getNamespaceId())) {
            request.setNamespaceId("public");
        }
    }

    private static void validateAgentCardField(String fieldName, String fieldValue) throws NacosApiException {
        if (StringUtils.isEmpty((String)fieldValue)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `agentCard." + fieldName + "` not present");
        }
    }
}

