/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.utils;

import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardBasicInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardVersionInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentInterface;
import com.alibaba.nacos.api.ai.model.a2a.AgentVersionDetail;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.StringUtils;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;

public class AgentCardUtil {
    private static final String AGENT_INTERFACE_URL_PATTERN = "%s://%s:%s";

    public static AgentCardDetailInfo buildAgentCardDetailInfo(AgentCard agentCard, String registrationType) {
        AgentCardDetailInfo agentCardDetailInfo = new AgentCardDetailInfo();
        AgentCardUtil.copyAgentCardInfo((AgentCard)agentCardDetailInfo, agentCard);
        agentCardDetailInfo.setRegistrationType(registrationType);
        return agentCardDetailInfo;
    }

    public static AgentCardVersionInfo buildAgentCardVersionInfo(AgentCard agentCard, String registrationType, boolean isLatest) {
        AgentCardVersionInfo agentCardVersionInfo = new AgentCardVersionInfo();
        AgentCardUtil.copyAgentCardBasicInfo((AgentCardBasicInfo)agentCardVersionInfo, (AgentCardBasicInfo)agentCard);
        agentCardVersionInfo.setRegistrationType(registrationType);
        if (isLatest) {
            agentCardVersionInfo.setLatestPublishedVersion(agentCard.getVersion());
        }
        agentCardVersionInfo.setVersionDetails(Collections.singletonList(AgentCardUtil.buildAgentVersionDetail(agentCard, isLatest)));
        return agentCardVersionInfo;
    }

    public static AgentVersionDetail buildAgentVersionDetail(AgentCard agentCard, boolean isLatest) {
        AgentVersionDetail agentVersionDetail = new AgentVersionDetail();
        agentVersionDetail.setCreatedAt(AgentCardUtil.getCurrentTime());
        agentVersionDetail.setUpdatedAt(AgentCardUtil.getCurrentTime());
        agentVersionDetail.setVersion(agentCard.getVersion());
        agentVersionDetail.setLatest(isLatest);
        return agentVersionDetail;
    }

    public static void updateUpdateTime(AgentVersionDetail versionDetail) {
        versionDetail.setUpdatedAt(AgentCardUtil.getCurrentTime());
    }

    public static AgentInterface buildAgentInterface(Instance instance) {
        AgentInterface agentInterface = new AgentInterface();
        boolean isSupportTls = Boolean.parseBoolean((String)instance.getMetadata().get("__nacos.agent.endpoint.supportTls__"));
        String protocol = isSupportTls ? "https" : "http";
        Object url = String.format(AGENT_INTERFACE_URL_PATTERN, protocol, instance.getIp(), instance.getPort());
        String path = (String)instance.getMetadata().get("__nacos.agent.endpoint.path__");
        if (StringUtils.isNotBlank((String)path)) {
            url = (String)url + (String)(path.startsWith("/") ? path : "/" + path);
        }
        agentInterface.setUrl((String)url);
        agentInterface.setTransport((String)instance.getMetadata().get("__nacos.agent.endpoint.transport__"));
        return agentInterface;
    }

    private static String getCurrentTime() {
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return currentTime.format(formatter);
    }

    private static void copyAgentCardInfo(AgentCard target, AgentCard source) {
        AgentCardUtil.copyAgentCardBasicInfo((AgentCardBasicInfo)target, (AgentCardBasicInfo)source);
        target.setUrl(source.getUrl());
        target.setPreferredTransport(source.getPreferredTransport());
        target.setAdditionalInterfaces(source.getAdditionalInterfaces());
        target.setProvider(source.getProvider());
        target.setSecuritySchemes(source.getSecuritySchemes());
        target.setSecurity(source.getSecurity());
        target.setDefaultInputModes(source.getDefaultInputModes());
        target.setDefaultOutputModes(source.getDefaultOutputModes());
        target.setSupportsAuthenticatedExtendedCard(source.getSupportsAuthenticatedExtendedCard());
        target.setDocumentationUrl(source.getDocumentationUrl());
    }

    private static void copyAgentCardBasicInfo(AgentCardBasicInfo target, AgentCardBasicInfo source) {
        target.setProtocolVersion(source.getProtocolVersion());
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        target.setVersion(source.getVersion());
        target.setIconUrl(source.getIconUrl());
        target.setCapabilities(source.getCapabilities());
        target.setSkills(source.getSkills());
    }
}

