/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service.a2a.identity;

import com.alibaba.nacos.ai.service.a2a.identity.AgentIdCodec;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Set;

public class AsciiAgentIdCodec
implements AgentIdCodec {
    private static final String ENCODE_PREFIX = "____:";
    private static final char ENCODE_MARK_CHAR = '_';
    private static final Set<Character> VALID_CHAR = Set.of(Character.valueOf('-'), Character.valueOf('.'), Character.valueOf(':'));

    @Override
    public String encode(String agentName) {
        if (!this.isNeedEncoded(agentName)) {
            return agentName;
        }
        StringBuilder sb = new StringBuilder(ENCODE_PREFIX);
        for (char ch : agentName.toCharArray()) {
            if (Character.isLetter(ch) || VALID_CHAR.contains(Character.valueOf(ch))) {
                sb.append(ch);
                continue;
            }
            sb.append('_').append(String.format("%03d", ch));
        }
        return sb.toString();
    }

    @Override
    public String encodeForSearch(String agentName) {
        String encodedName = this.encode(agentName);
        return this.isEncoded(encodedName) ? encodedName.substring(ENCODE_PREFIX.length()) : encodedName;
    }

    @Override
    public String decode(String agentId) {
        if (!this.isEncoded(agentId)) {
            return agentId;
        }
        String body = agentId.substring(ENCODE_PREFIX.length());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < body.length()) {
            String codePart;
            char ch = body.charAt(i);
            if (ch == '_' && i + 4 <= body.length() && this.isDigit(codePart = body.substring(i + 1, i + 4))) {
                int codePoint = Integer.parseInt(codePart, 10);
                sb.append((char)codePoint);
                i += 4;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    private boolean isDigit(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return s.length() == 3;
    }

    private boolean isEncoded(String name) {
        return name != null && name.startsWith(ENCODE_PREFIX);
    }

    private boolean isNeedEncoded(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        if (name.startsWith(ENCODE_PREFIX)) {
            return false;
        }
        for (char ch : name.toCharArray()) {
            if (Character.isLetter(ch) || VALID_CHAR.contains(Character.valueOf(ch))) continue;
            return true;
        }
        return false;
    }
}

