/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service.a2a;

import com.alibaba.nacos.ai.service.SyncEffectService;
import com.alibaba.nacos.ai.service.a2a.identity.AgentIdCodecHolder;
import com.alibaba.nacos.ai.utils.AgentCardUtil;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardVersionInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentInterface;
import com.alibaba.nacos.api.ai.model.a2a.AgentVersionDetail;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.exception.ConfigAlreadyExistsException;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class A2aServerOperationService {
    private final ConfigQueryChainService configQueryChainService;
    private final ConfigOperationService configOperationService;
    private final ConfigDetailService configDetailService;
    private final SyncEffectService syncEffectService;
    private final ServiceStorage serviceStorage;
    private final AgentIdCodecHolder agentIdCodecHolder;

    public A2aServerOperationService(ConfigQueryChainService configQueryChainService, ConfigOperationService configOperationService, ConfigDetailService configDetailService, SyncEffectService syncEffectService, ServiceStorage serviceStorage, AgentIdCodecHolder agentIdCodecHolder) {
        this.configQueryChainService = configQueryChainService;
        this.configOperationService = configOperationService;
        this.configDetailService = configDetailService;
        this.syncEffectService = syncEffectService;
        this.serviceStorage = serviceStorage;
        this.agentIdCodecHolder = agentIdCodecHolder;
    }

    public void registerAgent(AgentCard agentCard, String namespaceId, String registrationType) throws NacosException {
        try {
            AgentCardVersionInfo agentCardVersionInfo = AgentCardUtil.buildAgentCardVersionInfo(agentCard, registrationType, true);
            ConfigForm configForm = this.transferVersionInfoToConfigForm(agentCardVersionInfo, namespaceId);
            ConfigRequestInfo versionConfigRequest = new ConfigRequestInfo();
            versionConfigRequest.setUpdateForExist(Boolean.FALSE);
            this.configOperationService.publishConfig(configForm, versionConfigRequest, null);
            AgentCardDetailInfo agentCardDetailInfo = AgentCardUtil.buildAgentCardDetailInfo(agentCard, registrationType);
            ConfigForm configFormVersion = this.transferAgentInfoToConfigForm(agentCardDetailInfo, namespaceId);
            ConfigRequestInfo agentCardConfigRequest = new ConfigRequestInfo();
            agentCardConfigRequest.setUpdateForExist(Boolean.FALSE);
            long startOperationTime = System.currentTimeMillis();
            this.configOperationService.publishConfig(configFormVersion, agentCardConfigRequest, null);
            this.syncEffectService.toSync(configFormVersion, startOperationTime);
        }
        catch (ConfigAlreadyExistsException e) {
            throw new NacosApiException(409, ErrorCode.RESOURCE_CONFLICT, String.format("AgentCard name %s already exist", agentCard.getName()));
        }
    }

    public void deleteAgent(String namespaceId, String agentName, String version) throws NacosException {
        String encodedName = this.agentIdCodecHolder.encode(agentName);
        ConfigQueryChainRequest request = ConfigQueryChainRequest.buildConfigQueryChainRequest((String)encodedName, (String)"agent", (String)namespaceId);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (response.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND) {
            return;
        }
        AgentCardVersionInfo agentCardVersionInfo = (AgentCardVersionInfo)JacksonUtils.toObj((String)response.getContent(), AgentCardVersionInfo.class);
        List<String> allVersions = agentCardVersionInfo.getVersionDetails().stream().map(AgentVersionDetail::getVersion).toList();
        if (StringUtils.isNotEmpty((String)version)) {
            String versionDataId = encodedName + "-" + version;
            this.configOperationService.deleteConfig(versionDataId, "agent-version", namespaceId, null, null, "nacos", null);
            List versionDetails = agentCardVersionInfo.getVersionDetails();
            boolean isLatestVersion = version.equals(agentCardVersionInfo.getLatestPublishedVersion());
            if (versionDetails.size() == 1 && ((AgentVersionDetail)versionDetails.get(0)).getVersion().equals(version)) {
                this.configOperationService.deleteConfig(encodedName, "agent", namespaceId, null, null, "nacos", null);
            } else {
                agentCardVersionInfo.getVersionDetails().removeIf(versionDetail -> versionDetail.getVersion().equals(version));
                if (isLatestVersion) {
                    agentCardVersionInfo.setLatestPublishedVersion(null);
                    agentCardVersionInfo.setVersion(null);
                }
                ConfigForm updateForm = this.transferVersionInfoToConfigForm(agentCardVersionInfo, namespaceId);
                ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
                configRequestInfo.setUpdateForExist(Boolean.TRUE);
                this.configOperationService.publishConfig(updateForm, configRequestInfo, null);
            }
        } else {
            for (String each : allVersions) {
                String versionDataId = encodedName + "-" + each;
                this.configOperationService.deleteConfig(versionDataId, "agent-version", namespaceId, null, null, "nacos", null);
            }
            this.configOperationService.deleteConfig(encodedName, "agent", namespaceId, null, null, "nacos", null);
        }
    }

    public void updateAgentCard(AgentCard agentCard, String namespaceId, String registrationType, boolean setAsLatest) throws NacosException {
        AgentCardVersionInfo existingAgentInfo = this.queryAgentCardVersionInfo(namespaceId, agentCard.getName());
        boolean versionExisted = existingAgentInfo.getVersionDetails().stream().anyMatch(agentVersionDetail -> StringUtils.equals((String)agentVersionDetail.getVersion(), (String)agentCard.getVersion()));
        if (!versionExisted) {
            existingAgentInfo.getVersionDetails().add(AgentCardUtil.buildAgentVersionDetail(agentCard, setAsLatest));
        }
        if (StringUtils.isEmpty((String)registrationType)) {
            registrationType = existingAgentInfo.getRegistrationType();
        }
        AgentCardDetailInfo agentCardDetailInfo = AgentCardUtil.buildAgentCardDetailInfo(agentCard, registrationType);
        BeanUtils.copyProperties((Object)agentCardDetailInfo, (Object)existingAgentInfo, (String[])new String[]{"versionDetails", "latestPublishedVersion"});
        if (setAsLatest) {
            existingAgentInfo.setLatestPublishedVersion(agentCard.getVersion());
            List<AgentVersionDetail> updatedVersionDetails = existingAgentInfo.getVersionDetails().stream().peek(detail -> {
                if (StringUtils.equals((String)detail.getVersion(), (String)agentCard.getVersion())) {
                    detail.setLatest(true);
                    AgentCardUtil.updateUpdateTime(detail);
                } else {
                    detail.setLatest(false);
                }
            }).toList();
            existingAgentInfo.setVersionDetails(updatedVersionDetails);
        }
        ConfigForm configForm = this.transferVersionInfoToConfigForm(existingAgentInfo, namespaceId);
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setUpdateForExist(Boolean.TRUE);
        this.configOperationService.publishConfig(configForm, configRequestInfo, null);
        ConfigForm versionConfigForm = this.transferAgentInfoToConfigForm(agentCardDetailInfo, namespaceId);
        ConfigRequestInfo versionConfigRequestInfo = new ConfigRequestInfo();
        versionConfigRequestInfo.setUpdateForExist(Boolean.TRUE);
        long startOperationTime = System.currentTimeMillis();
        this.configOperationService.publishConfig(versionConfigForm, versionConfigRequestInfo, null);
        this.syncEffectService.toSync(versionConfigForm, startOperationTime);
    }

    public Page<AgentCardVersionInfo> listAgents(String namespaceId, String agentName, String search, int pageNo, int pageSize) throws NacosException {
        Object dataId;
        if (StringUtils.isEmpty((String)agentName) || "blur".equalsIgnoreCase(search)) {
            search = "blur";
            dataId = "*" + this.agentIdCodecHolder.encodeForSearch(agentName) + "*";
        } else {
            search = "accurate";
            dataId = this.agentIdCodecHolder.encode(agentName);
        }
        Page configInfoPage = this.configDetailService.findConfigInfoPage(search, pageNo, pageSize, (String)dataId, "agent", namespaceId, null);
        List<AgentCardVersionInfo> versionInfos = configInfoPage.getPageItems().stream().map(configInfo -> (AgentCardVersionInfo)JacksonUtils.toObj((String)configInfo.getContent(), AgentCardVersionInfo.class)).toList();
        Page result = new Page();
        result.setPageItems(versionInfos);
        result.setTotalCount(configInfoPage.getTotalCount());
        result.setPagesAvailable((int)Math.ceil((double)configInfoPage.getTotalCount() / (double)pageSize));
        result.setPageNumber(pageNo);
        return result;
    }

    public List<AgentVersionDetail> listAgentVersions(String namespaceId, String name) throws NacosApiException {
        AgentCardVersionInfo agentCardVersionInfo = this.queryAgentCardVersionInfo(namespaceId, name);
        return agentCardVersionInfo.getVersionDetails();
    }

    public AgentCardDetailInfo getAgentCard(String namespaceId, String agentName, String version, String registrationType) throws NacosApiException {
        AgentCardVersionInfo agentCardVersionInfo = this.queryAgentCardVersionInfo(namespaceId, agentName);
        return StringUtils.isEmpty((String)version) ? this.queryLatestVersion(agentCardVersionInfo, namespaceId, registrationType) : this.queryTargetVersion(agentCardVersionInfo, version, namespaceId, registrationType);
    }

    private AgentCardDetailInfo queryLatestVersion(AgentCardVersionInfo agentCardVersionInfo, String namespaceId, String registrationType) throws NacosApiException {
        String latestVersion = agentCardVersionInfo.getVersionDetails().stream().filter(AgentVersionDetail::isLatest).findFirst().orElseThrow(() -> new NacosApiException(404, ErrorCode.AGENT_VERSION_NOT_FOUND, String.format("Agent %s latest version not found", agentCardVersionInfo.getName()))).getVersion();
        return this.queryTargetVersion(agentCardVersionInfo, latestVersion, namespaceId, registrationType);
    }

    private AgentCardDetailInfo queryTargetVersion(AgentCardVersionInfo agentCardVersionInfo, String version, String namespaceId, String registrationType) throws NacosApiException {
        String versionDataId = this.agentIdCodecHolder.encode(agentCardVersionInfo.getName()) + "-" + version;
        ConfigQueryChainRequest request = ConfigQueryChainRequest.buildConfigQueryChainRequest((String)versionDataId, (String)"agent-version", (String)namespaceId);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (response.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND) {
            throw new NacosApiException(404, ErrorCode.AGENT_VERSION_NOT_FOUND, String.format("Agent %s version %s not found.", agentCardVersionInfo.getName(), version));
        }
        AgentCardDetailInfo result = (AgentCardDetailInfo)JacksonUtils.toObj((String)response.getContent(), AgentCardDetailInfo.class);
        if (StringUtils.isBlank((CharSequence)registrationType)) {
            registrationType = result.getRegistrationType();
        }
        if ("SERVICE".equalsIgnoreCase(registrationType)) {
            this.injectEndpoint(result, namespaceId);
        }
        if (agentCardVersionInfo.getLatestPublishedVersion().equals(result.getVersion())) {
            result.setLatestVersion(Boolean.valueOf(true));
        }
        return result;
    }

    private void injectEndpoint(AgentCardDetailInfo agentCard, String namespaceId) {
        String serviceName = this.agentIdCodecHolder.encode(agentCard.getName()) + "::" + agentCard.getVersion();
        com.alibaba.nacos.naming.core.v2.pojo.Service service = com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)namespaceId, (String)"agent-endpoints", (String)serviceName);
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        if (serviceInfo.getHosts().isEmpty()) {
            return;
        }
        List<AgentInterface> allAgentEndpoints = serviceInfo.getHosts().stream().map(AgentCardUtil::buildAgentInterface).toList();
        agentCard.setAdditionalInterfaces(allAgentEndpoints);
        List<AgentInterface> matchTransportEndpoints = allAgentEndpoints.stream().filter(agentInterface -> agentInterface.getTransport().equalsIgnoreCase(agentCard.getPreferredTransport())).toList();
        AgentInterface randomPreferredTransportEndpoint = this.randomOne(matchTransportEndpoints.isEmpty() ? allAgentEndpoints : matchTransportEndpoints);
        agentCard.setUrl(randomPreferredTransportEndpoint.getUrl());
        agentCard.setPreferredTransport(randomPreferredTransportEndpoint.getTransport());
    }

    private AgentInterface randomOne(List<AgentInterface> agentInterfaces) {
        return agentInterfaces.get(ThreadLocalRandom.current().nextInt(agentInterfaces.size()));
    }

    private ConfigForm transferVersionInfoToConfigForm(AgentCardVersionInfo agentCardVersionInfo, String namespaceId) {
        ConfigForm configForm = new ConfigForm();
        String actualDataId = this.agentIdCodecHolder.encode(agentCardVersionInfo.getName());
        configForm.setDataId(actualDataId);
        configForm.setGroup("agent");
        configForm.setNamespaceId(namespaceId);
        configForm.setContent(JacksonUtils.toJson((Object)agentCardVersionInfo));
        configForm.setConfigTags("nacos.internal.config=agent");
        configForm.setAppName(agentCardVersionInfo.getName());
        configForm.setSrcUser("nacos");
        configForm.setType(ConfigType.JSON.getType());
        return configForm;
    }

    private ConfigForm transferAgentInfoToConfigForm(AgentCardDetailInfo storageInfo, String namespaceId) {
        ConfigForm configForm = new ConfigForm();
        String actualDataId = this.agentIdCodecHolder.encode(storageInfo.getName()) + "-" + storageInfo.getVersion();
        configForm.setDataId(actualDataId);
        configForm.setGroup("agent-version");
        configForm.setNamespaceId(namespaceId);
        configForm.setContent(JacksonUtils.toJson((Object)storageInfo));
        configForm.setConfigTags("nacos.internal.config=agent-version");
        configForm.setAppName(storageInfo.getName());
        configForm.setSrcUser("nacos");
        configForm.setType(ConfigType.JSON.getType());
        return configForm;
    }

    private AgentCardVersionInfo queryAgentCardVersionInfo(String namespaceId, String name) throws NacosApiException {
        String actualDataId = this.agentIdCodecHolder.encode(name);
        ConfigQueryChainRequest request = ConfigQueryChainRequest.buildConfigQueryChainRequest((String)actualDataId, (String)"agent", (String)namespaceId);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (response.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND) {
            throw new NacosApiException(404, ErrorCode.AGENT_NOT_FOUND, "Agent not found: " + name);
        }
        return (AgentCardVersionInfo)JacksonUtils.toObj((String)response.getContent(), AgentCardVersionInfo.class);
    }
}

