/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportValidationResult;
import com.alibaba.nacos.api.ai.model.mcp.McpServerValidationItem;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McpServerValidationService {
    @Autowired
    private McpServerIndex mcpServerIndex;

    public McpServerImportValidationResult validateServers(String namespaceId, List<McpServerDetailInfo> servers) throws NacosException {
        McpServerImportValidationResult result = new McpServerImportValidationResult();
        ArrayList<McpServerValidationItem> validationItems = new ArrayList<McpServerValidationItem>();
        ArrayList<CallSite> overallErrors = new ArrayList<CallSite>();
        HashSet<String> serverNames = new HashSet<String>();
        int validCount = 0;
        int invalidCount = 0;
        int duplicateCount = 0;
        try {
            for (McpServerDetailInfo server : servers) {
                McpServerValidationItem item = this.validateSingleServer(namespaceId, server, serverNames);
                validationItems.add(item);
                switch (item.getStatus()) {
                    case "valid": {
                        ++validCount;
                        break;
                    }
                    case "invalid": {
                        ++invalidCount;
                        break;
                    }
                    case "duplicate": {
                        ++duplicateCount;
                        break;
                    }
                }
            }
            result.setValid(invalidCount == 0);
            result.setTotalCount(servers.size());
            result.setValidCount(validCount);
            result.setInvalidCount(invalidCount);
            result.setDuplicateCount(duplicateCount);
            result.setServers(validationItems);
            result.setErrors(overallErrors);
        }
        catch (Exception e) {
            overallErrors.add((CallSite)((Object)("Validation failed: " + e.getMessage())));
            result.setValid(false);
            result.setErrors(overallErrors);
        }
        return result;
    }

    private McpServerValidationItem validateSingleServer(String namespaceId, McpServerDetailInfo server, Set<String> existingNames) {
        McpServerValidationItem item = new McpServerValidationItem();
        ArrayList<String> errors = new ArrayList<String>();
        String serverName = server.getName();
        item.setServerName(serverName);
        item.setServerId(server.getId());
        item.setServer(server);
        if (StringUtils.isBlank((CharSequence)serverName)) {
            errors.add("Server name is required");
        }
        if (StringUtils.isBlank((CharSequence)server.getProtocol())) {
            errors.add("Protocol is required");
        } else if (!this.isValidProtocol(server.getProtocol())) {
            errors.add("Invalid protocol: " + server.getProtocol());
        }
        if (StringUtils.isBlank((CharSequence)server.getDescription())) {
            errors.add("Description is required");
        }
        if (existingNames.contains(serverName)) {
            errors.add("Duplicate server name in import batch: " + serverName);
            item.setStatus("duplicate");
        } else {
            existingNames.add(serverName);
        }
        try {
            McpServerIndexData existingServer = this.mcpServerIndex.getMcpServerByName(namespaceId, serverName);
            if (existingServer != null) {
                item.setExists(true);
                if (!"duplicate".equals(item.getStatus())) {
                    item.setStatus("duplicate");
                    errors.add("Server already exists: " + serverName);
                }
            }
        }
        catch (Exception e) {
            errors.add("Error checking existing server: " + e.getMessage());
        }
        this.validateProtocolSpecificConfig(server, errors);
        if (errors.isEmpty()) {
            item.setStatus("valid");
        } else if (!"duplicate".equals(item.getStatus())) {
            item.setStatus("invalid");
        }
        item.setErrors(errors);
        return item;
    }

    private boolean isValidProtocol(String protocol) {
        return "stdio".equals(protocol) || "mcp-sse".equals(protocol) || "mcp-streamable".equals(protocol) || "http".equals(protocol) || "dubbo".equals(protocol);
    }

    private void validateProtocolSpecificConfig(McpServerDetailInfo server, List<String> errors) {
        String protocol = server.getProtocol();
        if ("stdio".equals(protocol)) {
            if (server.getLocalServerConfig() == null && CollectionUtils.isEmpty((Collection)server.getPackages())) {
                errors.add("Local server configuration or packages are required for stdio protocol");
            }
        } else if (server.getRemoteServerConfig() == null) {
            errors.add("Remote server configuration is required for " + protocol + " protocol");
        }
        if (server.getToolSpec() != null && (server.getToolSpec().getTools() == null || server.getToolSpec().getTools().isEmpty())) {
            errors.add("Tool specification should contain at least one tool");
        }
    }
}

