/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.api.ai.model.mcp.FrontEndpointConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.registry.Argument;
import com.alibaba.nacos.api.ai.model.mcp.registry.McpRegistryServer;
import com.alibaba.nacos.api.ai.model.mcp.registry.McpRegistryServerDetail;
import com.alibaba.nacos.api.ai.model.mcp.registry.McpRegistryServerList;
import com.alibaba.nacos.api.ai.model.mcp.registry.Meta;
import com.alibaba.nacos.api.ai.model.mcp.registry.NamedArgument;
import com.alibaba.nacos.api.ai.model.mcp.registry.OfficialMeta;
import com.alibaba.nacos.api.ai.model.mcp.registry.Package;
import com.alibaba.nacos.api.ai.model.mcp.registry.PositionalArgument;
import com.alibaba.nacos.api.ai.model.mcp.registry.Remote;
import com.alibaba.nacos.api.ai.model.mcp.registry.ServerVersionDetail;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class McpServerTransformService {
    private static final String SERVERS_FIELD = "servers";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String PROTOCOL_JAVASCRIPT = "javascript:";
    private static final String PROTOCOL_DATA = "data:";
    private static final String PROTOCOL_FILE = "file:";
    private static final String METADATA_FIELD = "metadata";
    private static final String NEXT_CURSOR_FIELD = "next_cursor";
    private static final String CURSOR_QUERY_NAME = "cursor";
    private static final String LIMIT_QUERY_NAME = "limit";
    private static final String SEARCH_QUERY_NAME = "search";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_ACCEPT_JSON = "application/json";
    private static final String QUERY_MARK = "?";
    private static final String AMPERSAND = "&";
    private static final String AUTH_SCHEME_BEARER = "Bearer ";
    private static final int HTTP_STATUS_SUCCESS_MIN = 200;
    private static final int HTTP_STATUS_SUCCESS_MAX = 299;
    private static final int CONNECT_TIMEOUT_SECONDS = 10;
    private static final int READ_TIMEOUT_SECONDS = 20;
    private static final int MAX_PAGES_GUARD = 200;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<McpServerDetailInfo> transformToNacosFormat(String importData, String importType, String cursor, Integer limit, String search) throws Exception {
        return this.transformToNacosFormat(importData, ImportType.from(importType), cursor, limit, search);
    }

    public List<McpServerDetailInfo> transformToNacosFormat(String importData, ImportType type, String cursor, Integer limit, String search) throws Exception {
        List<McpServerDetailInfo> servers = switch (type.ordinal()) {
            case 0 -> this.parseFileToNacosServers(importData);
            case 1 -> this.parseJsonToNacosServers(importData);
            case 2 -> this.parseUrlData(importData, cursor, limit, search);
            default -> throw new IllegalArgumentException("Unsupported import type: " + String.valueOf((Object)type));
        };
        servers.forEach(server -> {
            if (StringUtils.isBlank((CharSequence)server.getId())) {
                server.setId(this.generateServerId(server.getName()));
            }
        });
        return servers;
    }

    public UrlPageResult fetchUrlPage(String urlData, String cursor, Integer limit, String search) throws Exception {
        if (StringUtils.isBlank((CharSequence)urlData)) {
            throw new IllegalArgumentException("URL is blank");
        }
        String base = urlData.trim();
        HttpClient client = this.createHttpClient();
        String bearer = this.resolveBearerToken();
        String pageUrl = this.buildPageUrl(base, cursor, limit, search);
        HttpRequest request = this.buildGetRequest(pageUrl, bearer);
        HttpResponse<String> resp = client.send(request, HttpResponse.BodyHandlers.ofString());
        int code = resp.statusCode();
        if (!this.isSuccessStatus(code)) {
            throw new IllegalStateException("HTTP " + code + " when fetching " + pageUrl);
        }
        ArrayList<McpServerDetailInfo> servers = new ArrayList<McpServerDetailInfo>();
        String next = null;
        try {
            McpRegistryServerList listPage = (McpRegistryServerList)this.objectMapper.readValue(resp.body(), McpRegistryServerList.class);
            if (listPage != null && listPage.getServers() != null) {
                for (McpRegistryServer registryServer : listPage.getServers()) {
                    McpServerDetailInfo server = this.transformRegistryServerToNacos(registryServer);
                    if (server == null) continue;
                    servers.add(server);
                }
            }
        }
        catch (Exception ignore) {
            throw new IllegalStateException("Failed to parse response body", ignore);
        }
        JsonNode root = this.objectMapper.readTree(resp.body());
        if (servers.isEmpty()) {
            this.appendServersFromRoot(root, servers);
        }
        next = this.extractNextCursor(root);
        servers.forEach(s -> {
            if (StringUtils.isBlank((CharSequence)s.getId())) {
                s.setId(this.generateServerId(s.getName()));
            }
        });
        return new UrlPageResult(servers, next);
    }

    public List<McpServerDetailInfo> fetchUrlServersAll(String urlData, String search) throws Exception {
        ArrayList<McpServerDetailInfo> collected = new ArrayList<McpServerDetailInfo>();
        String cursor = null;
        int pages = 0;
        while (pages < 200) {
            String next;
            ++pages;
            UrlPageResult page = this.fetchUrlPage(urlData, cursor, 30, search);
            if (page.getServers() != null && !page.getServers().isEmpty()) {
                collected.addAll(page.getServers());
            }
            if ((next = page.getNextCursor()) == null) break;
            cursor = next;
        }
        return collected;
    }

    private McpServerDetailInfo transformRegistryServerToNacos(McpRegistryServer registryServer) {
        if (registryServer == null) {
            return null;
        }
        try {
            String earlyProtocol;
            McpServerDetailInfo server = new McpServerDetailInfo();
            this.fillBasicInfo(registryServer, server);
            ServerVersionDetail versionDetail = this.buildVersion(registryServer);
            if (versionDetail != null) {
                server.setVersionDetail(versionDetail);
            }
            if (StringUtils.isNotBlank((String)(earlyProtocol = this.inferServerProtocol(registryServer)))) {
                server.setProtocol(earlyProtocol);
                server.setFrontProtocol(earlyProtocol);
            }
            if (registryServer instanceof McpRegistryServerDetail) {
                this.applyPackageConfigIfAny((McpRegistryServerDetail)registryServer, server);
            }
            if (registryServer instanceof McpRegistryServerDetail) {
                this.applyRemoteConfigIfAny((McpRegistryServerDetail)registryServer, server);
            }
            this.applyDefaultProtocolIfMissing(server);
            return server;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void fillBasicInfo(McpRegistryServer registryServer, McpServerDetailInfo out) {
        String id = this.resolveRegistryId(registryServer);
        out.setId(id);
        out.setName(registryServer.getName());
        out.setDescription(registryServer.getDescription());
        out.setStatus(registryServer.getStatus());
        if (registryServer.getRepository() != null) {
            out.setRepository(registryServer.getRepository());
        }
    }

    private String resolveRegistryId(McpRegistryServer registryServer) {
        String serverId;
        McpRegistryServerDetail detail;
        Meta meta;
        if (registryServer instanceof McpRegistryServerDetail && (meta = (detail = (McpRegistryServerDetail)registryServer).getMeta()) != null && meta.getOfficial() != null && StringUtils.isNotBlank((String)(serverId = meta.getOfficial().getServerId()))) {
            return serverId;
        }
        return registryServer.getRepository() != null ? registryServer.getRepository().getId() : null;
    }

    private ServerVersionDetail buildVersion(McpRegistryServer registryServer) {
        ServerVersionDetail v = null;
        if (StringUtils.isNotBlank((String)registryServer.getVersion())) {
            v = new ServerVersionDetail();
            v.setVersion(registryServer.getVersion());
        }
        if (registryServer instanceof McpRegistryServerDetail) {
            String release;
            OfficialMeta official;
            McpRegistryServerDetail detail = (McpRegistryServerDetail)registryServer;
            Meta meta = detail.getMeta();
            OfficialMeta officialMeta = official = meta != null ? meta.getOfficial() : null;
            if (v == null) {
                v = new ServerVersionDetail();
            }
            String string = release = official != null ? official.getPublishedAt() : null;
            if (StringUtils.isNotBlank((String)release)) {
                v.setRelease_date(release);
            }
            if (official != null && official.getIsLatest() != null) {
                v.setIs_latest(official.getIsLatest());
            }
        }
        return v;
    }

    private void applyPackageConfigIfAny(McpRegistryServerDetail detail, McpServerDetailInfo out) {
        if (detail.getPackages() == null || detail.getPackages().isEmpty()) {
            return;
        }
        out.setPackages(detail.getPackages());
    }

    private void applyRemoteConfigIfAny(McpRegistryServerDetail detail, McpServerDetailInfo out) {
        if (out.getRemoteServerConfig() != null) {
            return;
        }
        if (detail.getRemotes() == null || detail.getRemotes().isEmpty()) {
            return;
        }
        String protocol = this.resolveProtocolOrDefault(out);
        McpServerRemoteServiceConfig remoteConfig = new McpServerRemoteServiceConfig();
        this.configureRemoteService(remoteConfig, detail.getRemotes(), protocol);
        out.setRemoteServerConfig(remoteConfig);
    }

    private String resolveProtocolOrDefault(McpServerDetailInfo out) {
        return StringUtils.isNotBlank((String)out.getProtocol()) ? out.getProtocol() : "stdio";
    }

    private String inferServerProtocol(McpRegistryServer registryServer) {
        if (!(registryServer instanceof McpRegistryServerDetail)) {
            return null;
        }
        McpRegistryServerDetail detail = (McpRegistryServerDetail)registryServer;
        if (detail.getPackages() != null && !detail.getPackages().isEmpty()) {
            return "stdio";
        }
        if (detail.getRemotes() != null && !detail.getRemotes().isEmpty()) {
            String tt;
            Remote first = (Remote)detail.getRemotes().get(0);
            String string = tt = first != null ? first.getType() : null;
            if (tt != null) {
                String lower = tt.trim().toLowerCase();
                if ("sse".equals(lower)) {
                    return "mcp-sse";
                }
                if ("streamable-http".equals(lower)) {
                    return "mcp-streamable";
                }
            }
        }
        return null;
    }

    private void applyDefaultProtocolIfMissing(McpServerDetailInfo out) {
        if (StringUtils.isBlank((CharSequence)out.getProtocol())) {
            out.setProtocol("stdio");
            out.setFrontProtocol("stdio");
        }
    }

    private void configureRemoteService(McpServerRemoteServiceConfig remoteConfig, List<Remote> remotes, String protocol) {
        if (remoteConfig == null || remotes == null || remotes.isEmpty()) {
            return;
        }
        ArrayList<FrontEndpointConfig> endpoints = new ArrayList<FrontEndpointConfig>();
        for (Remote remote : remotes) {
            String url;
            if (remote == null || StringUtils.isBlank((CharSequence)remote.getUrl()) || !this.isValidUrl(url = remote.getUrl().trim(), "http")) continue;
            try {
                URI uri = URI.create(url);
                String scheme = uri.getScheme();
                String host = uri.getHost();
                int port = uri.getPort();
                String path = uri.getRawPath() + (String)(uri.getRawQuery() != null ? QUERY_MARK + uri.getRawQuery() : "") + (String)(uri.getRawFragment() != null ? "#" + uri.getRawFragment() : "");
                if (StringUtils.isBlank((CharSequence)host)) continue;
                boolean isHttps = "https".equalsIgnoreCase(scheme);
                int effectivePort = port > 0 ? port : (isHttps ? 443 : 80);
                String endpointData = host + ":" + effectivePort;
                remoteConfig.setExportPath(path);
                FrontEndpointConfig cfg = new FrontEndpointConfig();
                cfg.setEndpointData((Object)endpointData);
                cfg.setPath((String)(StringUtils.isNotBlank((String)path) ? path : "/"));
                cfg.setType(remote.getType());
                cfg.setProtocol(isHttps ? "https" : "http");
                cfg.setEndpointType("DIRECT");
                cfg.setHeaders(remote.getHeaders());
                endpoints.add(cfg);
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid URL: " + url, e);
            }
        }
        if (!endpoints.isEmpty()) {
            remoteConfig.setFrontEndpointConfigList(endpoints);
        }
    }

    private String mapTransportType(String transportType, String fallback) {
        String t;
        String string = t = transportType == null ? null : transportType.trim().toLowerCase();
        if ("sse".equals(t) || "mcp-sse".equalsIgnoreCase(transportType)) {
            return "mcp-sse";
        }
        if ("streamable-http".equals(t) || "mcp-streamable".equalsIgnoreCase(transportType)) {
            return "mcp-streamable";
        }
        if ("mcp-sse".equalsIgnoreCase(fallback)) {
            return "mcp-sse";
        }
        if ("mcp-streamable".equalsIgnoreCase(fallback)) {
            return "mcp-streamable";
        }
        return "mcp-sse";
    }

    private void configureRemoteServiceFromPackage(McpServerRemoteServiceConfig remoteConfig, Package mcpPackage, String protocol) {
        if (mcpPackage == null || remoteConfig == null) {
            return;
        }
        String registryName = mcpPackage.getRegistryType();
        String packageName = mcpPackage.getIdentifier();
        if (StringUtils.isNotBlank((String)registryName) && StringUtils.isNotBlank((String)packageName)) {
            String command = this.buildPackageCommand(registryName, packageName, mcpPackage);
            remoteConfig.setExportPath(command);
        }
    }

    private String buildPackageCommand(String registryName, String packageName, Package mcpPackage) {
        String argValue;
        StringBuilder command = new StringBuilder();
        String runtimeHint = null;
        try {
            runtimeHint = mcpPackage.getRuntimeHint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((String)runtimeHint)) {
            command.append(runtimeHint).append(" ");
            command.append(packageName);
        } else {
            switch (registryName.toLowerCase()) {
                case "npm": {
                    command.append("npx ").append(packageName);
                    break;
                }
                case "pypi": {
                    command.append("python -m ").append(packageName);
                    break;
                }
                case "oci": 
                case "docker": {
                    command.append("docker run ").append(packageName);
                    break;
                }
                default: {
                    command.append(packageName);
                }
            }
        }
        try {
            if (mcpPackage.getRuntimeArguments() != null) {
                for (Argument arg : mcpPackage.getRuntimeArguments()) {
                    argValue = this.extractArgumentValue(arg);
                    if (!StringUtils.isNotBlank((String)argValue)) continue;
                    command.append(" ").append(argValue);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (mcpPackage.getPackageArguments() != null) {
            for (Argument arg : mcpPackage.getPackageArguments()) {
                argValue = this.extractArgumentValue(arg);
                if (!StringUtils.isNotBlank((String)argValue)) continue;
                command.append(" ").append(argValue);
            }
        }
        return command.toString();
    }

    private String extractArgumentValue(Argument arg) {
        if (arg instanceof NamedArgument) {
            NamedArgument namedArg = (NamedArgument)arg;
            return namedArg.getValue();
        }
        if (arg instanceof PositionalArgument) {
            PositionalArgument positionalArg = (PositionalArgument)arg;
            return positionalArg.getValue();
        }
        return null;
    }

    private List<McpServerDetailInfo> parseUrlData(String urlData, String cursor, Integer limit, String search) throws Exception {
        if (StringUtils.isBlank((CharSequence)urlData)) {
            throw new IllegalArgumentException("URL is blank");
        }
        if (limit != null && limit == -1) {
            return this.fetchUrlServersAll(urlData.trim(), search);
        }
        UrlPageResult page = this.fetchUrlPage(urlData.trim(), cursor, limit, search);
        ArrayList result = page.getServers();
        return result != null ? result : new ArrayList();
    }

    private List<McpServerDetailInfo> parseFileToNacosServers(String data) throws Exception {
        ArrayList<McpServerDetailInfo> out = new ArrayList<McpServerDetailInfo>();
        List<McpRegistryServerDetail> details = this.parseFileToRegistryDetails(data);
        for (McpRegistryServerDetail d : details) {
            McpServerDetailInfo info = this.transformRegistryServerToNacos((McpRegistryServer)d);
            if (info == null) continue;
            out.add(info);
        }
        return out;
    }

    private List<McpServerDetailInfo> parseJsonToNacosServers(String data) throws Exception {
        ArrayList<McpServerDetailInfo> out = new ArrayList<McpServerDetailInfo>();
        McpRegistryServerDetail detail = this.parseJsonToRegistryDetail(data);
        McpServerDetailInfo info = this.transformRegistryServerToNacos((McpRegistryServer)detail);
        if (info != null) {
            out.add(info);
        }
        return out;
    }

    private List<McpRegistryServerDetail> parseFileToRegistryDetails(String data) throws Exception {
        ArrayList<McpRegistryServerDetail> out = new ArrayList<McpRegistryServerDetail>();
        JsonNode root = this.objectMapper.readTree(data);
        if (root.has(SERVERS_FIELD)) {
            JsonNode serversNode = root.get(SERVERS_FIELD);
            if (serversNode.isArray()) {
                for (JsonNode s : serversNode) {
                    McpRegistryServerDetail d = (McpRegistryServerDetail)this.objectMapper.treeToValue((TreeNode)s, McpRegistryServerDetail.class);
                    if (d == null) continue;
                    out.add(d);
                }
            }
        } else if (root.isArray()) {
            for (JsonNode s : root) {
                McpRegistryServerDetail d = (McpRegistryServerDetail)this.objectMapper.treeToValue((TreeNode)s, McpRegistryServerDetail.class);
                if (d == null) continue;
                out.add(d);
            }
        } else {
            McpRegistryServerDetail d = (McpRegistryServerDetail)this.objectMapper.treeToValue((TreeNode)root, McpRegistryServerDetail.class);
            if (d != null) {
                out.add(d);
            }
        }
        return out;
    }

    private McpRegistryServerDetail parseJsonToRegistryDetail(String data) throws Exception {
        JsonNode root = this.objectMapper.readTree(data);
        if (root.has(SERVERS_FIELD)) {
            JsonNode serversNode = root.get(SERVERS_FIELD);
            if (serversNode.isArray() && serversNode.size() > 0) {
                return (McpRegistryServerDetail)this.objectMapper.treeToValue((TreeNode)serversNode.get(0), McpRegistryServerDetail.class);
            }
            throw new IllegalArgumentException("Invalid json import: 'servers' is not an array or empty");
        }
        if (root.isArray()) {
            if (root.size() == 0) {
                throw new IllegalArgumentException("Invalid json import: empty array");
            }
            return (McpRegistryServerDetail)this.objectMapper.treeToValue((TreeNode)root.get(0), McpRegistryServerDetail.class);
        }
        return (McpRegistryServerDetail)this.objectMapper.treeToValue((TreeNode)root, McpRegistryServerDetail.class);
    }

    private HttpClient createHttpClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();
    }

    private String resolveBearerToken() {
        String bearer = System.getProperty("nacos.mcp.registry.token");
        if (StringUtils.isBlank((CharSequence)bearer)) {
            bearer = System.getenv("MCP_REGISTRY_TOKEN");
        }
        return StringUtils.isBlank((CharSequence)bearer) ? null : bearer.trim();
    }

    private String buildPageUrl(String base, String cursor, Integer limit, String search) {
        StringBuilder url = new StringBuilder(base);
        boolean hasQuery = base.contains(QUERY_MARK);
        if (StringUtils.isNotBlank((String)cursor)) {
            String enc = URLEncoder.encode(cursor, StandardCharsets.UTF_8);
            url.append(hasQuery ? AMPERSAND : QUERY_MARK).append(CURSOR_QUERY_NAME).append("=").append(enc);
            hasQuery = true;
        }
        if (limit != null && limit > 0) {
            url.append(hasQuery ? AMPERSAND : QUERY_MARK).append(LIMIT_QUERY_NAME).append("=").append(limit);
            hasQuery = true;
        }
        if (StringUtils.isNotBlank((String)search)) {
            String encSearch = URLEncoder.encode(search, StandardCharsets.UTF_8);
            url.append(hasQuery ? AMPERSAND : QUERY_MARK).append(SEARCH_QUERY_NAME).append("=").append(encSearch);
        }
        return url.toString();
    }

    private HttpRequest buildGetRequest(String url, String bearer) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(20L)).GET().header(HEADER_ACCEPT, HEADER_ACCEPT_JSON);
        if (StringUtils.isNotBlank((String)bearer)) {
            builder.header(HEADER_AUTHORIZATION, AUTH_SCHEME_BEARER + bearer);
        }
        return builder.build();
    }

    private void appendServersFromRoot(JsonNode root, List<McpServerDetailInfo> out) {
        JsonNode serversNode = root.get(SERVERS_FIELD);
        if (serversNode != null && serversNode.isArray()) {
            for (JsonNode serverNode : serversNode) {
                try {
                    McpRegistryServer registryServer = (McpRegistryServer)this.objectMapper.treeToValue((TreeNode)serverNode, McpRegistryServer.class);
                    McpServerDetailInfo server = this.transformRegistryServerToNacos(registryServer);
                    if (server == null) continue;
                    out.add(server);
                }
                catch (Exception registryServer) {}
            }
            return;
        }
        if (root.isArray()) {
            for (JsonNode serverNode : root) {
                try {
                    McpRegistryServer registryServer = (McpRegistryServer)this.objectMapper.treeToValue((TreeNode)serverNode, McpRegistryServer.class);
                    McpServerDetailInfo server = this.transformRegistryServerToNacos(registryServer);
                    if (server == null) continue;
                    out.add(server);
                }
                catch (Exception exception) {}
            }
            return;
        }
        try {
            McpRegistryServer registryServer = (McpRegistryServer)this.objectMapper.treeToValue((TreeNode)root, McpRegistryServer.class);
            McpServerDetailInfo server = this.transformRegistryServerToNacos(registryServer);
            if (server != null) {
                out.add(server);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractNextCursor(JsonNode root) {
        JsonNode nextNode;
        JsonNode metadata = root.get(METADATA_FIELD);
        if (metadata != null && metadata.isObject() && (nextNode = metadata.get(NEXT_CURSOR_FIELD)) != null && nextNode.isTextual()) {
            String next = nextNode.asText();
            return StringUtils.isBlank((CharSequence)next) ? null : next;
        }
        return null;
    }

    private boolean isSuccessStatus(int code) {
        return code >= 200 && code <= 299;
    }

    private String generateServerId(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return UUID.randomUUID().toString().replace("-", "");
        }
        String baseId = name.toLowerCase().replaceAll("[^a-z0-9]", "");
        String suffix = UUID.randomUUID().toString().substring(0, 8);
        return baseId + "-" + suffix;
    }

    private boolean isValidUrl(String url, String protocol) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        String lowerUrl = url.toLowerCase();
        if (lowerUrl.contains(PROTOCOL_JAVASCRIPT) || lowerUrl.contains(PROTOCOL_DATA) || lowerUrl.contains(PROTOCOL_FILE)) {
            return false;
        }
        switch (protocol) {
            case "http": {
                return lowerUrl.startsWith(HTTP_PREFIX) || lowerUrl.startsWith(HTTPS_PREFIX);
            }
            case "stdio": {
                return !lowerUrl.contains("..") && !lowerUrl.contains(AMPERSAND) && !lowerUrl.contains("|");
            }
            case "dubbo": {
                return lowerUrl.startsWith("dubbo://") || lowerUrl.startsWith(HTTP_PREFIX) || lowerUrl.startsWith(HTTPS_PREFIX);
            }
        }
        return !lowerUrl.contains("..") && !lowerUrl.contains(PROTOCOL_JAVASCRIPT) && !lowerUrl.contains(PROTOCOL_DATA);
    }

    private static enum ImportType {
        FILE,
        JSON,
        URL;


        static ImportType from(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Unsupported import type: null");
            }
            switch (s.trim().toLowerCase()) {
                case "file": {
                    return FILE;
                }
                case "json": {
                    return JSON;
                }
                case "url": {
                    return URL;
                }
            }
            throw new IllegalArgumentException("Unsupported import type: " + s);
        }
    }

    public static class UrlPageResult {
        private final List<McpServerDetailInfo> servers;
        private final String nextCursor;

        public UrlPageResult(List<McpServerDetailInfo> servers, String nextCursor) {
            this.servers = servers;
            this.nextCursor = nextCursor;
        }

        public List<McpServerDetailInfo> getServers() {
            return this.servers;
        }

        public String getNextCursor() {
            return this.nextCursor;
        }
    }
}

