/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.ai.service.McpServerOperationService;
import com.alibaba.nacos.ai.service.McpServerTransformService;
import com.alibaba.nacos.ai.service.McpServerValidationService;
import com.alibaba.nacos.api.ai.model.mcp.FrontEndpointConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportRequest;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportResponse;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportResult;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportValidationResult;
import com.alibaba.nacos.api.ai.model.mcp.McpServerValidationItem;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class McpServerImportService {
    private static final Logger LOG = LoggerFactory.getLogger(McpServerImportService.class);
    private static final int MAX_IMPORT_BATCH_SIZE = 100;
    private final McpServerTransformService transformService;
    private final McpServerValidationService validationService;
    private final McpServerOperationService operationService;
    private static final String IMPORT_TYPE_URL = "url";

    public McpServerImportService(McpServerTransformService transformService, McpServerValidationService validationService, McpServerOperationService operationService) {
        this.transformService = transformService;
        this.validationService = validationService;
        this.operationService = operationService;
    }

    public McpServerImportValidationResult validateImport(String namespaceId, McpServerImportRequest request) throws NacosException {
        try {
            List<McpServerDetailInfo> servers = this.transformService.transformToNacosFormat(request.getData(), request.getImportType(), request.getCursor(), request.getLimit(), request.getSearch());
            return this.validationService.validateServers(namespaceId, servers);
        }
        catch (Exception e) {
            McpServerImportValidationResult result = new McpServerImportValidationResult();
            result.setValid(false);
            ArrayList<CallSite> errors = new ArrayList<CallSite>();
            errors.add((CallSite)((Object)("Import validation failed: " + e.getMessage())));
            result.setErrors(errors);
            return result;
        }
    }

    public McpServerImportResponse executeImport(String namespaceId, McpServerImportRequest request) throws NacosException {
        McpServerImportResponse response = new McpServerImportResponse();
        ArrayList<McpServerImportResult> results = new ArrayList<McpServerImportResult>();
        try {
            int invalid;
            McpServerImportValidationResult validationResult = this.validateImport(namespaceId, request);
            if (!validationResult.isValid() && !request.isSkipInvalid()) {
                response.setSuccess(false);
                response.setErrorMessage("Import validation failed: " + String.join((CharSequence)", ", validationResult.getErrors()));
                return response;
            }
            List<McpServerValidationItem> serversToImport = this.filterSelectedServers(validationResult.getServers(), request.getSelectedServers());
            if (!validationResult.isValid() && request.isSkipInvalid() && serversToImport.isEmpty()) {
                response.setSuccess(false);
                Object msg = "Import validation failed and no valid servers to import";
                if (validationResult.getErrors() != null && !validationResult.getErrors().isEmpty()) {
                    msg = (String)msg + ": " + String.join((CharSequence)", ", validationResult.getErrors());
                }
                response.setErrorMessage((String)msg);
                response.setTotalCount(0);
                response.setResults(results);
                return response;
            }
            int successCount = 0;
            int failedCount = 0;
            int skippedCount = 0;
            for (McpServerValidationItem item : serversToImport) {
                McpServerImportResult result = this.importSingleServer(namespaceId, item, request.isOverrideExisting());
                results.add(result);
                switch (result.getStatus()) {
                    case "success": {
                        ++successCount;
                        break;
                    }
                    case "failed": {
                        ++failedCount;
                        break;
                    }
                    case "skipped": {
                        ++skippedCount;
                        break;
                    }
                }
            }
            response.setSuccess(failedCount == 0);
            response.setTotalCount(serversToImport.size());
            response.setSuccessCount(successCount);
            response.setFailedCount(failedCount);
            response.setSkippedCount(skippedCount);
            response.setResults(results);
            if (!validationResult.isValid() && request.isSkipInvalid() && (invalid = validationResult.getInvalidCount()) > 0) {
                String baseMsg = "Some invalid servers were skipped: " + invalid;
                response.setErrorMessage(baseMsg);
            }
        }
        catch (Exception e) {
            LOG.error("Import execution failed", (Throwable)e);
            response.setSuccess(false);
            response.setErrorMessage("Import execution failed: " + e.getMessage());
        }
        return response;
    }

    private List<McpServerValidationItem> filterSelectedServers(List<McpServerValidationItem> validationItems, String[] selectedServers) {
        if (validationItems == null || validationItems.isEmpty()) {
            return Collections.emptyList();
        }
        if (selectedServers == null || selectedServers.length == 0) {
            return validationItems.stream().filter(item -> "valid".equals(item.getStatus())).collect(Collectors.toList());
        }
        HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(selectedServers));
        return validationItems.stream().filter(item -> selectedSet.contains(item.getServerId()) && "valid".equals(item.getStatus())).collect(Collectors.toList());
    }

    private McpServerImportResult importSingleServer(String namespaceId, McpServerValidationItem item, boolean overrideExisting) {
        McpServerImportResult result = new McpServerImportResult();
        result.setServerName(item.getServerName());
        result.setServerId(item.getServerId());
        try {
            if (item.isExists() && !overrideExisting) {
                result.setStatus("skipped");
                result.setConflictType("existing");
                return result;
            }
            McpServerDetailInfo server = item.getServer();
            McpServerBasicInfo basicInfo = new McpServerBasicInfo();
            basicInfo.setId(server.getId());
            basicInfo.setName(server.getName());
            basicInfo.setProtocol(server.getProtocol());
            basicInfo.setFrontProtocol(server.getFrontProtocol());
            basicInfo.setDescription(server.getDescription());
            basicInfo.setStatus(server.getStatus());
            basicInfo.setRepository(server.getRepository());
            basicInfo.setVersionDetail(server.getVersionDetail());
            basicInfo.setRemoteServerConfig(server.getRemoteServerConfig());
            basicInfo.setPackages(server.getPackages());
            McpToolSpecification toolSpec = server.getToolSpec();
            McpEndpointSpec endpointSpec = this.convertToEndpointSpec(server);
            if (item.isExists() && overrideExisting) {
                this.operationService.updateMcpServer(namespaceId, true, basicInfo, toolSpec, endpointSpec, overrideExisting);
            } else {
                this.operationService.createMcpServer(namespaceId, basicInfo, toolSpec, endpointSpec);
            }
            result.setStatus("success");
        }
        catch (Exception e) {
            result.setStatus("failed");
            result.setErrorMessage("Failed to import server: " + e.getMessage());
        }
        return result;
    }

    private McpEndpointSpec convertToEndpointSpec(McpServerDetailInfo server) {
        if ("stdio".equals(server.getProtocol())) {
            return null;
        }
        McpEndpointSpec endpointSpec = new McpEndpointSpec();
        try {
            if (server.getRemoteServerConfig() == null || server.getRemoteServerConfig().getFrontEndpointConfigList() == null || server.getRemoteServerConfig().getFrontEndpointConfigList().isEmpty()) {
                return endpointSpec;
            }
            FrontEndpointConfig first = (FrontEndpointConfig)server.getRemoteServerConfig().getFrontEndpointConfigList().get(0);
            Object epDataObj = first.getEndpointData();
            String epData = epDataObj == null ? null : (epDataObj instanceof String ? (String)epDataObj : String.valueOf(epDataObj));
            String[] hp = epData.split(":");
            endpointSpec.setType("DIRECT");
            endpointSpec.getData().put("address", hp[0] == null ? "" : hp[0]);
            endpointSpec.getData().put("port", hp[1] == null ? "" : hp[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return endpointSpec;
    }
}

