/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.manager;

import com.alibaba.nacos.core.remote.ClientConnectionEventListener;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.v2.DistroClientVerifyInfo;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.ConnectionBasedClientManager;
import java.util.Collection;
import org.springframework.stereotype.Service;

@Service
public class AiConnectionBasedClientManager
extends ClientConnectionEventListener
implements ClientManager {
    private final ConnectionBasedClientManager delegate;

    public AiConnectionBasedClientManager(ConnectionBasedClientManager connectionBasedClientManager) {
        this.delegate = connectionBasedClientManager;
    }

    public void clientConnected(Connection connect) {
        if (!"ai".equals(connect.getMetaInfo().getLabel("module"))) {
            return;
        }
        ClientAttributes attributes = new ClientAttributes();
        attributes.addClientAttribute("connectionType", (Object)connect.getMetaInfo().getConnectType());
        attributes.addClientAttribute("connectionMetadata", (Object)connect.getMetaInfo());
        this.clientConnected(connect.getMetaInfo().getConnectionId(), attributes);
    }

    public boolean clientConnected(String clientId, ClientAttributes attributes) {
        return this.delegate.clientConnected(clientId, attributes);
    }

    public boolean clientConnected(Client client) {
        return this.delegate.clientConnected(client);
    }

    public boolean syncClientConnected(String clientId, ClientAttributes attributes) {
        return this.delegate.syncClientConnected(clientId, attributes);
    }

    public void clientDisConnected(Connection connect) {
        if (!"ai".equals(connect.getMetaInfo().getLabel("module"))) {
            return;
        }
        this.clientDisconnected(connect.getMetaInfo().getConnectionId());
    }

    public boolean clientDisconnected(String clientId) {
        return this.delegate.clientDisconnected(clientId);
    }

    public Client getClient(String clientId) {
        return this.delegate.getClient(clientId);
    }

    public boolean contains(String clientId) {
        return this.delegate.contains(clientId);
    }

    public Collection<String> allClientId() {
        return this.delegate.allClientId();
    }

    public boolean isResponsibleClient(Client client) {
        return this.delegate.isResponsibleClient(client);
    }

    public boolean verifyClient(DistroClientVerifyInfo verifyData) {
        return this.delegate.verifyClient(verifyData);
    }
}

