/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.handler.a2a;

import com.alibaba.nacos.ai.service.a2a.A2aServerOperationService;
import com.alibaba.nacos.ai.utils.AgentRequestUtil;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.remote.request.AbstractAgentRequest;
import com.alibaba.nacos.api.ai.remote.request.ReleaseAgentCardRequest;
import com.alibaba.nacos.api.ai.remote.response.ReleaseAgentCardResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.AgentRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReleaseAgentCardRequestHandler
extends RequestHandler<ReleaseAgentCardRequest, ReleaseAgentCardResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReleaseAgentCardRequestHandler.class);
    private final A2aServerOperationService a2aServerOperationService;

    public ReleaseAgentCardRequestHandler(A2aServerOperationService a2aServerOperationService) {
        this.a2aServerOperationService = a2aServerOperationService;
    }

    @NamespaceValidation
    @ExtractorManager.Extractor(rpcExtractor=AgentRequestParamExtractor.class)
    @Secured(action=ActionTypes.WRITE, signType="ai")
    public ReleaseAgentCardResponse handle(ReleaseAgentCardRequest request, RequestMeta meta) throws NacosException {
        AgentRequestUtil.fillNamespaceId((AbstractAgentRequest)request);
        ReleaseAgentCardResponse response = new ReleaseAgentCardResponse();
        try {
            this.validateRequest(request);
            this.doHandler(request, meta);
            return response;
        }
        catch (NacosException e) {
            response.setErrorInfo(e.getErrCode(), e.getErrMsg());
            LOGGER.error("[{}] Release agent card {} error: {}", new Object[]{meta.getConnectionId(), null == request.getAgentCard() ? null : JacksonUtils.toJson((Object)request.getAgentCard()), e.getErrMsg()});
            return response;
        }
    }

    private void validateRequest(ReleaseAgentCardRequest request) throws NacosApiException {
        if (null == request.getAgentCard()) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `agentCard` can't be null");
        }
        AgentRequestUtil.validateAgentCard(request.getAgentCard());
    }

    private void doHandler(ReleaseAgentCardRequest request, RequestMeta meta) throws NacosException {
        String namespaceId = request.getNamespaceId();
        AgentCard agentCard = request.getAgentCard();
        LOGGER.info("Release new agent {}, version {} into namespaceId {} from connectionId {}.", new Object[]{agentCard.getName(), agentCard.getVersion(), namespaceId, meta.getConnectionId()});
        try {
            AgentCardDetailInfo existAgentCard = this.a2aServerOperationService.getAgentCard(namespaceId, agentCard.getName(), agentCard.getVersion(), "");
            LOGGER.info("AgentCard {} and target version {} already exist.", (Object)existAgentCard.getName(), (Object)existAgentCard.getVersion());
        }
        catch (NacosApiException e) {
            if (ErrorCode.AGENT_NOT_FOUND.getCode().intValue() == e.getDetailErrCode()) {
                this.createAgentCard(namespaceId, agentCard, request.getRegistrationType());
                LOGGER.info("AgentCard {} released.", (Object)agentCard.getName());
            }
            if (ErrorCode.AGENT_VERSION_NOT_FOUND.getCode().intValue() == e.getDetailErrCode()) {
                this.createNewVersionAgentCard(namespaceId, agentCard, request.getRegistrationType(), request.isSetAsLatest());
                LOGGER.info("AgentCard {} new version {} released.", (Object)agentCard.getName(), (Object)agentCard.getVersion());
            }
            LOGGER.error("AgentCard {} released failed.", (Object)agentCard.getName(), (Object)e);
            throw e;
        }
    }

    private void createAgentCard(String namespaceId, AgentCard agentCard, String registrationType) throws NacosException {
        this.a2aServerOperationService.registerAgent(agentCard, namespaceId, registrationType);
    }

    private void createNewVersionAgentCard(String namespaceId, AgentCard agentCard, String registrationType, boolean setAsLatest) throws NacosException {
        this.a2aServerOperationService.updateAgentCard(agentCard, namespaceId, registrationType, setAsLatest);
    }
}

