/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.handler.a2a;

import com.alibaba.nacos.ai.service.a2a.A2aServerOperationService;
import com.alibaba.nacos.ai.utils.AgentRequestUtil;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.remote.request.AbstractAgentRequest;
import com.alibaba.nacos.api.ai.remote.request.QueryAgentCardRequest;
import com.alibaba.nacos.api.ai.remote.response.QueryAgentCardResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.AgentRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QueryAgentCardRequestHandler
extends RequestHandler<QueryAgentCardRequest, QueryAgentCardResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryAgentCardRequestHandler.class);
    private final A2aServerOperationService a2aServerOperationService;

    public QueryAgentCardRequestHandler(A2aServerOperationService a2aServerOperationService) {
        this.a2aServerOperationService = a2aServerOperationService;
    }

    @NamespaceValidation
    @ExtractorManager.Extractor(rpcExtractor=AgentRequestParamExtractor.class)
    @Secured(action=ActionTypes.READ, signType="ai")
    public QueryAgentCardResponse handle(QueryAgentCardRequest request, RequestMeta meta) throws NacosException {
        AgentRequestUtil.fillNamespaceId((AbstractAgentRequest)request);
        if (StringUtils.isBlank((CharSequence)request.getAgentName())) {
            QueryAgentCardResponse errorResponse = new QueryAgentCardResponse();
            errorResponse.setErrorInfo(400, "parameters `agentName` can't be empty or null");
            return errorResponse;
        }
        return this.doHandler(request);
    }

    private QueryAgentCardResponse doHandler(QueryAgentCardRequest request) {
        QueryAgentCardResponse response = new QueryAgentCardResponse();
        try {
            AgentCardDetailInfo result = this.a2aServerOperationService.getAgentCard(request.getNamespaceId(), request.getAgentName(), request.getVersion(), request.getRegistrationType());
            response.setAgentCardDetailInfo(result);
        }
        catch (NacosException e) {
            LOGGER.error("Query agent card for agent {} error: {}", (Object)request.getAgentName(), (Object)e.getErrMsg());
            response.setErrorInfo(e.getErrCode(), e.getErrMsg());
        }
        return response;
    }
}

