/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.handler.a2a;

import com.alibaba.nacos.ai.service.a2a.identity.AgentIdCodecHolder;
import com.alibaba.nacos.ai.utils.AgentRequestUtil;
import com.alibaba.nacos.api.ai.model.a2a.AgentEndpoint;
import com.alibaba.nacos.api.ai.remote.request.AbstractAgentRequest;
import com.alibaba.nacos.api.ai.remote.request.AgentEndpointRequest;
import com.alibaba.nacos.api.ai.remote.response.AgentEndpointResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.AgentRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.impl.EphemeralClientOperationServiceImpl;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AgentEndpointRequestHandler
extends RequestHandler<AgentEndpointRequest, AgentEndpointResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentEndpointRequestHandler.class);
    private final EphemeralClientOperationServiceImpl clientOperationService;
    private final AgentIdCodecHolder agentIdCodecHolder;

    public AgentEndpointRequestHandler(EphemeralClientOperationServiceImpl clientOperationService, AgentIdCodecHolder agentIdCodecHolder) {
        this.clientOperationService = clientOperationService;
        this.agentIdCodecHolder = agentIdCodecHolder;
    }

    @NamespaceValidation
    @ExtractorManager.Extractor(rpcExtractor=AgentRequestParamExtractor.class)
    @Secured(action=ActionTypes.WRITE, signType="ai")
    public AgentEndpointResponse handle(AgentEndpointRequest request, RequestMeta meta) throws NacosException {
        AgentEndpointResponse response = new AgentEndpointResponse();
        response.setType(request.getType());
        AgentRequestUtil.fillNamespaceId((AbstractAgentRequest)request);
        try {
            this.validateRequest(request);
            Instance instance = this.transferInstance(request);
            String serviceName = this.agentIdCodecHolder.encode(request.getAgentName()) + "::" + request.getEndpoint().getVersion();
            Service service = Service.newService((String)request.getNamespaceId(), (String)"agent-endpoints", (String)serviceName);
            switch (request.getType()) {
                case "registerEndpoint": {
                    this.doRegisterEndpoint(service, instance, meta);
                    break;
                }
                case "deregisterEndpoint": {
                    this.doDeregisterEndpoint(service, instance, meta);
                    break;
                }
                default: {
                    throw new NacosApiException(400, ErrorCode.PARAMETER_VALIDATE_ERROR, String.format("parameter `type` should be %s or %s, but was %s", "registerEndpoint", "deregisterEndpoint", request.getType()));
                }
            }
        }
        catch (NacosApiException e) {
            response.setErrorInfo(e.getErrCode(), e.getErrMsg());
            LOGGER.error("[{}] Register agent endpoint to agent {} error: {}", new Object[]{meta.getConnectionId(), request.getAgentName(), e.getErrMsg()});
        }
        return response;
    }

    private Instance transferInstance(AgentEndpointRequest request) throws NacosApiException {
        Instance instance = new Instance();
        AgentEndpoint endpoint = request.getEndpoint();
        instance.setIp(endpoint.getAddress());
        instance.setPort(endpoint.getPort());
        String path = StringUtils.isBlank((CharSequence)endpoint.getPath()) ? "" : endpoint.getPath();
        Map<String, String> metadata = Map.of("__nacos.agent.endpoint.path__", path, "__nacos.agent.endpoint.transport__", endpoint.getTransport(), "__nacos.agent.endpoint.supportTls__", String.valueOf(endpoint.isSupportTls()));
        instance.setMetadata(metadata);
        instance.validate();
        return instance;
    }

    private void validateRequest(AgentEndpointRequest request) throws NacosApiException {
        if (StringUtils.isBlank((CharSequence)request.getAgentName())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `agentName` can't be empty or null");
        }
        if (null == request.getEndpoint()) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `endpoint` can't be null");
        }
        if (StringUtils.isBlank((CharSequence)request.getEndpoint().getVersion())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `endpoint.version` can't be empty or null");
        }
    }

    private void doRegisterEndpoint(Service service, Instance instance, RequestMeta meta) throws NacosException {
        this.clientOperationService.registerInstance(service, instance, meta.getConnectionId());
    }

    private void doDeregisterEndpoint(Service service, Instance instance, RequestMeta meta) {
        this.clientOperationService.deregisterInstance(service, instance, meta.getConnectionId());
    }
}

