/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.handler;

import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.ai.service.McpEndpointOperationService;
import com.alibaba.nacos.ai.service.McpServerOperationService;
import com.alibaba.nacos.ai.utils.McpRequestUtil;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.ai.remote.request.AbstractMcpRequest;
import com.alibaba.nacos.api.ai.remote.request.ReleaseMcpServerRequest;
import com.alibaba.nacos.api.ai.remote.response.ReleaseMcpServerResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.McpServerRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReleaseMcpServerRequestHandler
extends RequestHandler<ReleaseMcpServerRequest, ReleaseMcpServerResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReleaseMcpServerRequest.class);
    private final McpServerOperationService mcpServerOperationService;
    private final McpEndpointOperationService endpointOperationService;
    private final McpServerIndex mcpServerIndex;

    public ReleaseMcpServerRequestHandler(McpServerOperationService mcpServerOperationService, McpEndpointOperationService endpointOperationService, McpServerIndex mcpServerIndex) {
        this.mcpServerOperationService = mcpServerOperationService;
        this.endpointOperationService = endpointOperationService;
        this.mcpServerIndex = mcpServerIndex;
    }

    @NamespaceValidation
    @ExtractorManager.Extractor(rpcExtractor=McpServerRequestParamExtractor.class)
    @Secured(action=ActionTypes.WRITE, signType="ai")
    public ReleaseMcpServerResponse handle(ReleaseMcpServerRequest request, RequestMeta meta) throws NacosException {
        McpRequestUtil.fillNamespaceId((AbstractMcpRequest)request);
        try {
            this.checkParameters(request);
            return this.doHandler(request, meta);
        }
        catch (NacosException e) {
            ReleaseMcpServerResponse response = new ReleaseMcpServerResponse();
            response.setErrorInfo(e.getErrCode(), e.getErrMsg());
            return response;
        }
    }

    private void checkParameters(ReleaseMcpServerRequest request) throws NacosException {
        McpServerBasicInfo serverSpecification = request.getServerSpecification();
        if (null == serverSpecification) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter 'serverSpecification' type McpServerBasicInfo is not present");
        }
        String mcpName = serverSpecification.getName();
        if (StringUtils.isEmpty((String)mcpName)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter 'serverSpecification.name' type String is not present");
        }
        if (null == serverSpecification.getVersionDetail() || StringUtils.isBlank((CharSequence)serverSpecification.getVersionDetail().getVersion())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Required parameter `serverSpecification.versionDetail.version` not present");
        }
    }

    private ReleaseMcpServerResponse doHandler(ReleaseMcpServerRequest request, RequestMeta meta) throws NacosException {
        String namespaceId = request.getNamespaceId();
        McpServerBasicInfo serverSpecification = request.getServerSpecification();
        LOGGER.info("Release new mcp server {}, version {} into namespaceId {} from connectionId {}.", new Object[]{serverSpecification.getName(), serverSpecification.getVersionDetail().getVersion(), namespaceId, meta.getConnectionId()});
        ReleaseMcpServerResponse response = new ReleaseMcpServerResponse();
        try {
            McpServerDetailInfo existMcpServer = this.mcpServerOperationService.getMcpServerDetail(namespaceId, serverSpecification.getId(), serverSpecification.getName(), serverSpecification.getVersionDetail().getVersion());
            String version = existMcpServer.getVersionDetail().getVersion();
            LOGGER.info("Mcp Server {} and target version {} already exist.", (Object)existMcpServer.getName(), (Object)version);
            throw new NacosApiException(409, ErrorCode.MCP_SERVER_VERSION_EXIST, String.format("Mcp Server %s and target version %s already exist, do not do release", existMcpServer.getName(), version));
        }
        catch (NacosApiException e) {
            if (ErrorCode.MCP_SERVER_NOT_FOUND.getCode().intValue() == e.getDetailErrCode()) {
                String mcpId = this.createNewMcpServer(namespaceId, request);
                response.setMcpId(mcpId);
                LOGGER.info("Mcp Server {} released, Mcp Server id: {}", (Object)serverSpecification.getName(), (Object)mcpId);
            } else if (ErrorCode.MCP_SEVER_VERSION_NOT_FOUND.getCode().intValue() == e.getDetailErrCode()) {
                this.createNewVersionMcpServer(namespaceId, request);
                McpServerIndexData mcpServerIndexData = this.mcpServerIndex.getMcpServerByName(namespaceId, serverSpecification.getName());
                response.setMcpId(mcpServerIndexData.getId());
                LOGGER.info("Mcp Server {} new version {} released, Mcp Server id: {}", new Object[]{serverSpecification.getName(), serverSpecification.getVersionDetail().getVersion(), mcpServerIndexData.getId()});
            } else {
                LOGGER.error("Mcp Server {} released failed.", (Object)serverSpecification.getName(), (Object)e);
                throw e;
            }
            return response;
        }
    }

    private String createNewMcpServer(String namespaceId, ReleaseMcpServerRequest request) throws NacosException {
        McpServerBasicInfo mcpServerBasicInfo = request.getServerSpecification();
        McpToolSpecification toolSpecification = request.getToolSpecification();
        McpEndpointSpec endpointSpecification = null == request.getEndpointSpecification() ? this.autoBuildMcpEndpointSpecification(namespaceId, mcpServerBasicInfo) : request.getEndpointSpecification();
        return this.mcpServerOperationService.createMcpServer(namespaceId, mcpServerBasicInfo, toolSpecification, endpointSpecification);
    }

    private void createNewVersionMcpServer(String namespaceId, ReleaseMcpServerRequest request) throws NacosException {
        McpServerBasicInfo mcpServerBasicInfo = request.getServerSpecification();
        McpToolSpecification toolSpecification = request.getToolSpecification();
        McpEndpointSpec endpointSpecification = null == request.getEndpointSpecification() ? this.autoBuildMcpEndpointSpecification(namespaceId, mcpServerBasicInfo) : request.getEndpointSpecification();
        Boolean isLatest = mcpServerBasicInfo.getVersionDetail().getIs_latest();
        boolean isPublish = isLatest != null && isLatest != false;
        this.mcpServerOperationService.updateMcpServer(namespaceId, isPublish, mcpServerBasicInfo, toolSpecification, endpointSpecification, Boolean.FALSE);
    }

    private McpEndpointSpec autoBuildMcpEndpointSpecification(String namespaceId, McpServerBasicInfo mcpServerBasicInfo) {
        if ("stdio".equals(mcpServerBasicInfo.getProtocol())) {
            return null;
        }
        return this.autoBuildMcpEndpointSpecification(namespaceId, mcpServerBasicInfo.getName(), mcpServerBasicInfo.getVersionDetail().getVersion());
    }

    private McpEndpointSpec autoBuildMcpEndpointSpecification(String namespaceId, String mcpName, String version) {
        String versionMcpName = mcpName + "::" + version;
        Service service = this.endpointOperationService.generateService(namespaceId, versionMcpName);
        McpEndpointSpec endpointSpecification = new McpEndpointSpec();
        endpointSpecification.setType("REF");
        endpointSpecification.getData().put("namespaceId", service.getNamespace());
        endpointSpecification.getData().put("groupName", service.getGroup());
        endpointSpecification.getData().put("serviceName", service.getName());
        return endpointSpecification;
    }
}

