/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.handler;

import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.ai.service.McpServerOperationService;
import com.alibaba.nacos.ai.utils.McpRequestUtil;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.remote.request.AbstractMcpRequest;
import com.alibaba.nacos.api.ai.remote.request.QueryMcpServerRequest;
import com.alibaba.nacos.api.ai.remote.response.QueryMcpServerResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.McpServerRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.springframework.stereotype.Component;

@Component
public class QueryMcpServerRequestHandler
extends RequestHandler<QueryMcpServerRequest, QueryMcpServerResponse> {
    private final McpServerOperationService mcpServerOperationService;
    private final McpServerIndex mcpServerIndex;

    public QueryMcpServerRequestHandler(McpServerOperationService mcpServerOperationService, McpServerIndex mcpServerIndex) {
        this.mcpServerOperationService = mcpServerOperationService;
        this.mcpServerIndex = mcpServerIndex;
    }

    @NamespaceValidation
    @ExtractorManager.Extractor(rpcExtractor=McpServerRequestParamExtractor.class)
    @Secured(action=ActionTypes.READ, signType="ai")
    public QueryMcpServerResponse handle(QueryMcpServerRequest request, RequestMeta meta) throws NacosException {
        McpRequestUtil.fillNamespaceId((AbstractMcpRequest)request);
        if (StringUtils.isBlank((CharSequence)request.getMcpName())) {
            QueryMcpServerResponse errorResponse = new QueryMcpServerResponse();
            errorResponse.setErrorInfo(400, "parameters `mcpName` can't be empty or null");
            return errorResponse;
        }
        return this.doHandler(request, meta);
    }

    private QueryMcpServerResponse doHandler(QueryMcpServerRequest request, RequestMeta meta) throws NacosException {
        McpServerIndexData indexData = this.mcpServerIndex.getMcpServerByName(request.getNamespaceId(), request.getMcpName());
        QueryMcpServerResponse response = new QueryMcpServerResponse();
        if (null == indexData) {
            response.setErrorInfo(404, String.format("MCP server `%s` not found in namespaceId: `%s`", request.getMcpName(), request.getNamespaceId()));
            return response;
        }
        McpServerDetailInfo detailInfo = this.mcpServerOperationService.getMcpServerDetail(request.getNamespaceId(), indexData.getId(), null, request.getVersion());
        response.setMcpServerDetailInfo(detailInfo);
        return response;
    }
}

