/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.remote.handler;

import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.ai.service.McpServerOperationService;
import com.alibaba.nacos.ai.utils.McpRequestUtil;
import com.alibaba.nacos.api.ai.model.mcp.FrontEndpointConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.remote.request.AbstractMcpRequest;
import com.alibaba.nacos.api.ai.remote.request.McpServerEndpointRequest;
import com.alibaba.nacos.api.ai.remote.response.McpServerEndpointResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.filter.NamespaceValidation;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.McpServerRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.impl.EphemeralClientOperationServiceImpl;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class McpServerEndpointRequestHandler
extends RequestHandler<McpServerEndpointRequest, McpServerEndpointResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpServerEndpointRequestHandler.class);
    private static final String VERSION_TAG = "_mcp_server_version";
    private final EphemeralClientOperationServiceImpl clientOperationService;
    private final McpServerOperationService mcpServerOperationService;
    private final McpServerIndex mcpServerIndex;

    public McpServerEndpointRequestHandler(EphemeralClientOperationServiceImpl clientOperationService, McpServerOperationService mcpServerOperationService, McpServerIndex mcpServerIndex) {
        this.clientOperationService = clientOperationService;
        this.mcpServerOperationService = mcpServerOperationService;
        this.mcpServerIndex = mcpServerIndex;
    }

    @NamespaceValidation
    @ExtractorManager.Extractor(rpcExtractor=McpServerRequestParamExtractor.class)
    @Secured(action=ActionTypes.WRITE, signType="ai")
    public McpServerEndpointResponse handle(McpServerEndpointRequest request, RequestMeta meta) throws NacosException {
        McpRequestUtil.fillNamespaceId((AbstractMcpRequest)request);
        try {
            this.checkParameters(request);
            Instance instance = this.buildInstance(request);
            return this.doHandler(request, instance, meta);
        }
        catch (NacosException e) {
            McpServerEndpointResponse response = new McpServerEndpointResponse();
            response.setErrorInfo(e.getErrCode(), e.getErrMsg());
            return response;
        }
    }

    private void checkParameters(McpServerEndpointRequest request) throws NacosApiException {
        if (StringUtils.isBlank((CharSequence)request.getMcpName())) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "parameters `mcpName` can't be empty or null");
        }
    }

    private McpServerEndpointResponse doHandler(McpServerEndpointRequest request, Instance instance, RequestMeta meta) throws NacosException {
        McpServerIndexData indexData = this.mcpServerIndex.getMcpServerByName(request.getNamespaceId(), request.getMcpName());
        if (null == indexData) {
            throw new NacosApiException(404, ErrorCode.MCP_SERVER_NOT_FOUND, String.format("MCP server `%s` not found in namespaceId: `%s`", request.getMcpName(), request.getNamespaceId()));
        }
        McpServerDetailInfo mcpServer = this.mcpServerOperationService.getMcpServerDetail(request.getNamespaceId(), indexData.getId(), null, request.getVersion());
        McpServiceRef serviceRef = this.buildServiceRef(mcpServer);
        if (null == serviceRef) {
            throw new NacosApiException(404, ErrorCode.MCP_SERVER_REF_ENDPOINT_SERVICE_NOT_FOUND, "The Mcp Server Ref endpoint service not found.");
        }
        Service service = Service.newService((String)request.getNamespaceId(), (String)serviceRef.getGroupName(), (String)serviceRef.getServiceName(), (boolean)true);
        switch (request.getType()) {
            case "registerEndpoint": {
                LOGGER.info("[{}] register endpoint {}:{} version {} for mcp server: {}", new Object[]{meta.getConnectionId(), request.getAddress(), request.getPort(), request.getVersion(), request.getMcpName()});
                this.doRegister(service, instance, meta.getConnectionId());
                break;
            }
            case "deregisterEndpoint": {
                LOGGER.info("[{}] de-register endpoint {}:{} version {} for mcp server: {}", new Object[]{meta.getConnectionId(), request.getAddress(), request.getPort(), request.getVersion(), request.getMcpName()});
                this.doDeregister(service, instance, meta.getConnectionId());
                break;
            }
            default: {
                throw new NacosApiException(400, ErrorCode.PARAMETER_VALIDATE_ERROR, String.format("parameter `type` should be %s or %s, but was %s", "registerEndpoint", "deregisterEndpoint", request.getType()));
            }
        }
        McpServerEndpointResponse response = new McpServerEndpointResponse();
        response.setType(request.getType());
        return response;
    }

    private Instance buildInstance(McpServerEndpointRequest request) throws NacosApiException {
        Instance instance = new Instance();
        instance.setIp(request.getAddress());
        instance.setPort(request.getPort());
        instance.validate();
        if (StringUtils.isNotBlank((String)request.getVersion())) {
            instance.getMetadata().put(VERSION_TAG, request.getVersion());
        }
        return instance;
    }

    private McpServiceRef buildServiceRef(McpServerDetailInfo mcpServer) {
        boolean isRegisterToFrontend = "http".equals(mcpServer.getProtocol());
        McpServiceRef result = null;
        if (isRegisterToFrontend) {
            for (FrontEndpointConfig each : mcpServer.getRemoteServerConfig().getFrontEndpointConfigList()) {
                if (!"REF".equals(each.getEndpointType())) continue;
                result = McpRequestUtil.transferToMcpServiceRef(each.getEndpointData());
                break;
            }
        } else {
            result = mcpServer.getRemoteServerConfig().getServiceRef();
        }
        return result;
    }

    private void doRegister(Service service, Instance instance, String connectionId) throws NacosException {
        this.clientOperationService.registerInstance(service, instance, connectionId);
    }

    private void doDeregister(Service service, Instance instance, String connectionId) {
        this.clientOperationService.deregisterInstance(service, instance, connectionId);
    }
}

