/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.param;

import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;

public class AgentHttpParamExtractor
extends AbstractHttpParamExtractor {
    private static final String AGENT_CARD_PARAM = "agentCard";

    public List<ParamInfo> extractParam(HttpServletRequest request) throws NacosException {
        ParamInfo paramInfo = new ParamInfo();
        paramInfo.setNamespaceId(request.getParameter("namespaceId"));
        paramInfo.setAgentName(request.getParameter("agentName"));
        if (request.getParameterMap().containsKey(AGENT_CARD_PARAM)) {
            paramInfo.setAgentName(this.deserializeAndGetAgentName(request.getParameter(AGENT_CARD_PARAM)));
        }
        return Collections.singletonList(paramInfo);
    }

    private String deserializeAndGetAgentName(String agentCardJson) {
        try {
            AgentCard agentCard = (AgentCard)JacksonUtils.toObj((String)agentCardJson, AgentCard.class);
            return agentCard.getName();
        }
        catch (Exception ignored) {
            return "";
        }
    }
}

