/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.index;

import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.ai.utils.McpConfigUtils;
import com.alibaba.nacos.api.ai.model.mcp.McpServerVersionInfo;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class PlainMcpServerIndex
implements McpServerIndex {
    private final ConfigDetailService configDetailService;
    private final NamespaceOperationService namespaceOperationService;
    private final ConfigQueryChainService configQueryChainService;

    public PlainMcpServerIndex(NamespaceOperationService namespaceOperationService, ConfigDetailService configDetailService, ConfigQueryChainService configQueryChainService) {
        this.namespaceOperationService = namespaceOperationService;
        this.configDetailService = configDetailService;
        this.configQueryChainService = configQueryChainService;
    }

    @Override
    public Page<McpServerIndexData> searchMcpServerByName(String namespaceId, String name, String search, int offset, int limit) {
        return this.searchMcpServerByName0(namespaceId, name, search, offset, limit);
    }

    private Page<McpServerIndexData> searchMcpServerByName0(String namespaceId, String name, String search, int offset, int limit) {
        int pageNo = offset / limit + 1;
        Page<ConfigInfo> serverInfos = this.searchMcpServers(namespaceId, name, search, pageNo, limit);
        List<McpServerIndexData> indexDataList = serverInfos.getPageItems().stream().map(this::mapMcpServerVersionConfigToIndexData).toList();
        Page result = new Page();
        result.setPageItems(indexDataList);
        result.setTotalCount(serverInfos.getTotalCount());
        result.setPagesAvailable((int)Math.ceil((double)serverInfos.getTotalCount() / (double)limit));
        result.setPageNumber(pageNo);
        return result;
    }

    private McpServerIndexData mapMcpServerVersionConfigToIndexData(ConfigInfo configInfo) {
        McpServerIndexData data = new McpServerIndexData();
        McpServerVersionInfo versionInfo = (McpServerVersionInfo)JacksonUtils.toObj((String)configInfo.getContent(), McpServerVersionInfo.class);
        data.setId(versionInfo.getId());
        data.setNamespaceId(configInfo.getTenant());
        return data;
    }

    private Page<ConfigInfo> searchMcpServers(String namespace, String serverName, String search, int pageNo, int limit) {
        HashMap<String, String> advanceInfo = new HashMap<String, String>(1);
        if (Objects.isNull(serverName)) {
            serverName = "";
        }
        String dataId = "*";
        if ("blur".equals(search) || StringUtils.isEmpty((String)serverName)) {
            String nameTag = McpConfigUtils.formatServerNameTagBlurSearchValue(serverName);
            advanceInfo.put("config_tags", nameTag);
            search = "blur";
        } else {
            advanceInfo.put("config_tags", McpConfigUtils.formatServerNameTagAccurateSearchValue(serverName));
            dataId = null;
        }
        return this.configDetailService.findConfigInfoPage(search, pageNo, limit, dataId, "mcp-server-versions", namespace, advanceInfo);
    }

    @Override
    public McpServerIndexData getMcpServerById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        List<String> namespaceList = this.fetchOrderedNamespaceList();
        for (String namespaceId : namespaceList) {
            McpServerIndexData result = this.getMcpServerById(namespaceId, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public McpServerIndexData getMcpServerById(String namespaceId, String id) {
        ConfigQueryChainRequest request = this.buildConfigQueryChainRequest(namespaceId, id);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (McpConfigUtils.isConfigFound(response.getStatus())) {
            return McpServerIndexData.newIndexData(id, namespaceId);
        }
        return null;
    }

    private ConfigQueryChainRequest buildConfigQueryChainRequest(String namespaceId, String serverId) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setTenant(namespaceId);
        request.setDataId(McpConfigUtils.formatServerVersionInfoDataId(serverId));
        request.setGroup("mcp-server-versions");
        return request;
    }

    @Override
    public McpServerIndexData getMcpServerByName(String namespaceId, String name) {
        Page<McpServerIndexData> indexDataPage = this.searchMcpServerByName(namespaceId, name, "accurate", 0, 1);
        if (CollectionUtils.isNotEmpty((Collection)indexDataPage.getPageItems())) {
            return (McpServerIndexData)indexDataPage.getPageItems().get(0);
        }
        return null;
    }

    private List<String> fetchOrderedNamespaceList() {
        return this.namespaceOperationService.getNamespaceList().stream().sorted(Comparator.comparing(Namespace::getNamespace)).map(Namespace::getNamespace).toList();
    }

    @Override
    public void removeMcpServerByName(String namespaceId, String mcpName) {
    }

    @Override
    public void removeMcpServerById(String mcpId) {
    }
}

