/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.index;

import com.alibaba.nacos.ai.config.McpCacheIndexProperties;
import com.alibaba.nacos.ai.index.McpCacheIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMcpCacheIndex
implements McpCacheIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryMcpCacheIndex.class);
    private static final int DEFAULT_SHUTDOWN_TIMEOUT_SECONDS = 5;
    private final McpCacheIndexProperties properties;
    private final ConcurrentHashMap<String, CacheNode> idToEntry;
    private final ConcurrentHashMap<String, String> nameKeyToId;
    private final CacheNode head;
    private final CacheNode tail;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final AtomicLong hitCount;
    private final AtomicLong missCount;
    private final AtomicLong evictionCount;
    private final ScheduledExecutorService cleanupScheduler;
    private volatile boolean shutdown = false;

    public MemoryMcpCacheIndex(McpCacheIndexProperties properties) {
        this.properties = properties;
        this.idToEntry = new ConcurrentHashMap(properties.getMaxSize());
        this.nameKeyToId = new ConcurrentHashMap();
        this.head = new CacheNode("", null, 0L);
        this.head.next = this.tail = new CacheNode("", null, 0L);
        this.tail.prev = this.head;
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.hitCount = new AtomicLong(0L);
        this.missCount = new AtomicLong(0L);
        this.evictionCount = new AtomicLong(0L);
        this.cleanupScheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r, "mcp-cache-cleanup");
            t.setDaemon(true);
            return t;
        }, new ThreadPoolExecutor.CallerRunsPolicy());
        this.cleanupScheduler.scheduleWithFixedDelay(this::cleanupExpiredEntries, properties.getCleanupIntervalSeconds(), properties.getCleanupIntervalSeconds(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMcpId(String namespaceId, String mcpName) {
        if (StringUtils.isBlank((CharSequence)namespaceId) || StringUtils.isBlank((CharSequence)mcpName)) {
            return null;
        }
        String key = this.buildNameKey(namespaceId, mcpName);
        this.readLock.lock();
        try {
            String id = this.nameKeyToId.get(key);
            if (id == null) {
                this.missCount.incrementAndGet();
                String string = null;
                return string;
            }
            CacheNode node = this.idToEntry.get(id);
            if (node == null || node.isExpired(this.properties.getExpireTimeSeconds())) {
                this.nameKeyToId.remove(key, id);
                if (node != null) {
                    this.removeFromLru(node);
                    this.idToEntry.remove(id, node);
                }
                this.missCount.incrementAndGet();
                String string = null;
                return string;
            }
            this.moveToHead(node);
            this.hitCount.incrementAndGet();
            String string = id;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public McpServerIndexData getMcpServerByName(String namespaceId, String mcpName) {
        String id = this.getMcpId(namespaceId, mcpName);
        if (id == null) {
            return null;
        }
        return this.getMcpServerById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public McpServerIndexData getMcpServerById(String mcpId) {
        if (StringUtils.isBlank((CharSequence)mcpId)) {
            return null;
        }
        this.readLock.lock();
        try {
            CacheNode node = this.idToEntry.get(mcpId);
            if (node == null || node.isExpired(this.properties.getExpireTimeSeconds())) {
                if (node != null) {
                    this.removeFromLru(node);
                    this.idToEntry.remove(mcpId, node);
                    this.cleanupInvalidMappings(mcpId);
                }
                this.missCount.incrementAndGet();
                McpServerIndexData mcpServerIndexData = null;
                return mcpServerIndexData;
            }
            this.moveToHead(node);
            this.hitCount.incrementAndGet();
            McpServerIndexData mcpServerIndexData = node.data;
            return mcpServerIndexData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndex(String namespaceId, String mcpName, String mcpId) {
        if (StringUtils.isBlank((CharSequence)namespaceId) || StringUtils.isBlank((CharSequence)mcpName) || StringUtils.isBlank((CharSequence)mcpId)) {
            return;
        }
        McpServerIndexData data = McpServerIndexData.newIndexData(mcpId, namespaceId);
        CacheNode newNode = new CacheNode(mcpId, data, System.currentTimeMillis() / 1000L);
        this.writeLock.lock();
        try {
            CacheNode oldNode = this.idToEntry.put(mcpId, newNode);
            if (oldNode != null) {
                this.removeFromLru(oldNode);
            }
            this.addToHead(newNode);
            while (this.idToEntry.size() > this.properties.getMaxSize()) {
                this.evictLeastRecentlyUsed();
            }
            String key = this.buildNameKey(namespaceId, mcpName);
            this.nameKeyToId.put(key, mcpId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeIndex(String namespaceId, String mcpName) {
        CacheNode node;
        if (StringUtils.isBlank((CharSequence)namespaceId) || StringUtils.isBlank((CharSequence)mcpName)) {
            return;
        }
        String key = this.buildNameKey(namespaceId, mcpName);
        String id = this.nameKeyToId.remove(key);
        if (id != null && (node = this.idToEntry.remove(id)) != null) {
            this.removeFromLru(node);
        }
    }

    @Override
    public void removeIndex(String mcpId) {
        if (StringUtils.isBlank((CharSequence)mcpId)) {
            return;
        }
        CacheNode node = this.idToEntry.remove(mcpId);
        if (node != null) {
            this.removeFromLru(node);
        }
        this.cleanupInvalidMappings(mcpId);
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.idToEntry.clear();
            this.nameKeyToId.clear();
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }
        finally {
            this.writeLock.unlock();
        }
        this.hitCount.set(0L);
        this.missCount.set(0L);
        this.evictionCount.set(0L);
    }

    @Override
    public int getSize() {
        return this.idToEntry.size();
    }

    @Override
    public McpCacheIndex.CacheStats getStats() {
        return new McpCacheIndex.CacheStats(this.hitCount.get(), this.missCount.get(), this.evictionCount.get(), this.getSize());
    }

    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.cleanupScheduler.shutdown();
            try {
                if (!this.cleanupScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.cleanupScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.cleanupScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.clear();
        }
    }

    private String buildNameKey(String namespaceId, String mcpName) {
        return namespaceId + "::" + mcpName;
    }

    private void cleanupInvalidMappings(String mcpId) {
        this.nameKeyToId.entrySet().removeIf(entry -> mcpId.equals(entry.getValue()));
    }

    private void cleanupExpiredEntries() {
        if (this.shutdown) {
            return;
        }
        try {
            Iterator<Map.Entry<String, CacheNode>> iterator = this.idToEntry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, CacheNode> entry = iterator.next();
                CacheNode node = entry.getValue();
                if (!node.isExpired(this.properties.getExpireTimeSeconds())) continue;
                iterator.remove();
                this.removeFromLru(node);
                this.cleanupInvalidMappings(entry.getKey());
                this.evictionCount.incrementAndGet();
            }
        }
        catch (Exception e) {
            LOGGER.error("Clean up expired mcp id and name cache failed.", (Throwable)e);
        }
    }

    private void evictLeastRecentlyUsed() {
        CacheNode removed;
        CacheNode last = this.tail.prev;
        if (last != this.head && (removed = this.idToEntry.remove(last.key)) != null) {
            this.removeFromLru(last);
            this.cleanupInvalidMappings(last.key);
            this.evictionCount.incrementAndGet();
        }
    }

    private void addToHead(CacheNode node) {
        node.prev = this.head;
        node.next = this.head.next;
        this.head.next.prev = node;
        this.head.next = node;
    }

    private synchronized void removeFromLru(CacheNode node) {
        if (node.prev != null && node.next != null) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
    }

    private synchronized void moveToHead(CacheNode node) {
        if (node.prev != null && node.next != null) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        node.prev = this.head;
        node.next = this.head.next;
        this.head.next.prev = node;
        this.head.next = node;
    }

    private static class CacheNode {
        final String key;
        final McpServerIndexData data;
        final long createTimeSeconds;
        volatile CacheNode prev;
        volatile CacheNode next;

        CacheNode(String key, McpServerIndexData data, long createTimeSeconds) {
            this.key = key;
            this.data = data;
            this.createTimeSeconds = createTimeSeconds;
        }

        boolean isExpired(long expireTimeSeconds) {
            if (expireTimeSeconds <= 0L) {
                return false;
            }
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            return currentTimeSeconds - this.createTimeSeconds >= expireTimeSeconds;
        }
    }
}

