/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.index;

import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;

public interface McpCacheIndex {
    public String getMcpId(String var1, String var2);

    public McpServerIndexData getMcpServerByName(String var1, String var2);

    public McpServerIndexData getMcpServerById(String var1);

    public void updateIndex(String var1, String var2, String var3);

    public void removeIndex(String var1, String var2);

    public void removeIndex(String var1);

    public void clear();

    public int getSize();

    public CacheStats getStats();

    public static class CacheStats {
        private final long hitCount;
        private final long missCount;
        private final long evictionCount;
        private final long size;

        public CacheStats(long hitCount, long missCount, long evictionCount, long size) {
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.evictionCount = evictionCount;
            this.size = size;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getMissCount() {
            return this.missCount;
        }

        public long getEvictionCount() {
            return this.evictionCount;
        }

        public long getSize() {
            return this.size;
        }

        public double getHitRate() {
            long total = this.hitCount + this.missCount;
            return total == 0L ? 0.0 : (double)this.hitCount / (double)total;
        }
    }
}

