/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.index;

import com.alibaba.nacos.ai.index.McpCacheIndex;
import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.model.mcp.McpServerIndexData;
import com.alibaba.nacos.ai.utils.McpConfigUtils;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMcpServerIndex
implements McpServerIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedMcpServerIndex.class);
    private final McpCacheIndex cacheIndex;
    private final ConfigDetailService configDetailService;
    private final NamespaceOperationService namespaceOperationService;
    private final ConfigQueryChainService configQueryChainService;
    private final ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> syncTask;
    private final boolean cacheEnabled;
    private final long syncInterval;

    public CachedMcpServerIndex(ConfigDetailService configDetailService, NamespaceOperationService namespaceOperationService, ConfigQueryChainService configQueryChainService, McpCacheIndex cacheIndex, ScheduledExecutorService scheduledExecutor, boolean cacheEnabled, long syncInterval) {
        this.configDetailService = configDetailService;
        this.namespaceOperationService = namespaceOperationService;
        this.configQueryChainService = configQueryChainService;
        this.cacheIndex = cacheIndex;
        this.scheduledExecutor = scheduledExecutor;
        this.cacheEnabled = cacheEnabled;
        this.syncInterval = syncInterval;
        if (cacheEnabled) {
            this.startSyncTask();
        }
        LOGGER.info("CachedMcpServerIndex initialized with cacheEnabled={}, syncInterval={}s", (Object)cacheEnabled, (Object)syncInterval);
    }

    @Override
    public Page<McpServerIndexData> searchMcpServerByName(String namespaceId, String name, String search, int offset, int limit) {
        return this.searchFromDatabase(namespaceId, name, search, offset, limit);
    }

    @Override
    public McpServerIndexData getMcpServerById(String id) {
        if (!this.cacheEnabled) {
            LOGGER.debug("Cache disabled, querying directly from database for mcpId: {}", (Object)id);
            return this.getMcpServerByIdFromDatabase(id);
        }
        McpServerIndexData cachedData = this.cacheIndex.getMcpServerById(id);
        if (cachedData != null) {
            LOGGER.debug("Cache hit for mcpId: {}", (Object)id);
            return cachedData;
        }
        LOGGER.debug("Cache miss for mcpId: {}, querying database", (Object)id);
        McpServerIndexData dbData = this.getMcpServerByIdFromDatabase(id);
        if (dbData != null) {
            this.cacheIndex.updateIndex(dbData.getNamespaceId(), dbData.getId(), dbData.getId());
            LOGGER.debug("Updated cache for mcpId: {}", (Object)id);
        }
        return dbData;
    }

    @Override
    public McpServerIndexData getMcpServerByName(String namespaceId, String name) {
        if (namespaceId == null || name == null || namespaceId.isEmpty() || name.isEmpty()) {
            LOGGER.warn("Invalid parameters for getMcpServerByName: namespaceId={}, name={}", (Object)namespaceId, (Object)name);
            return null;
        }
        if (!this.cacheEnabled) {
            LOGGER.debug("Cache disabled, querying directly from database for name: {}:{}", (Object)namespaceId, (Object)name);
            return this.getMcpServerByNameFromDatabase(namespaceId, name);
        }
        McpServerIndexData cachedData = this.cacheIndex.getMcpServerByName(namespaceId, name);
        if (cachedData != null) {
            LOGGER.debug("Cache hit for name: {}:{}", (Object)namespaceId, (Object)name);
            return cachedData;
        }
        LOGGER.debug("Cache miss for name: {}:{}, querying database", (Object)namespaceId, (Object)name);
        McpServerIndexData dbData = this.getMcpServerByNameFromDatabase(namespaceId, name);
        if (dbData != null) {
            this.cacheIndex.updateIndex(namespaceId, name, dbData.getId());
            LOGGER.debug("Updated cache for name: {}:{}", (Object)namespaceId, (Object)name);
        }
        return dbData;
    }

    private Page<McpServerIndexData> searchFromDatabase(String namespaceId, String name, String search, int offset, int limit) {
        int pageNo = offset / limit + 1;
        LOGGER.debug("Searching from database: namespaceId={}, name={}, search={}, pageNo={}, limit={}", new Object[]{namespaceId, name, search, pageNo, limit});
        Page<ConfigInfo> serverInfos = this.searchMcpServers(namespaceId, name, search, pageNo, limit);
        List<McpServerIndexData> indexDataList = serverInfos.getPageItems().stream().map(this::mapMcpServerVersionConfigToIndexData).toList();
        Page result = new Page();
        result.setPageItems(indexDataList);
        result.setTotalCount(serverInfos.getTotalCount());
        result.setPagesAvailable((int)Math.ceil((double)serverInfos.getTotalCount() / (double)limit));
        result.setPageNumber(pageNo);
        if (this.cacheEnabled) {
            for (McpServerIndexData indexData : indexDataList) {
                this.cacheIndex.updateIndex(indexData.getNamespaceId(), name, indexData.getId());
            }
            LOGGER.debug("Updated cache with {} entries from search results", (Object)indexDataList.size());
        }
        return result;
    }

    private McpServerIndexData getMcpServerByIdFromDatabase(String id) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setDataId(id + "-mcp-versions.json");
        request.setGroup("mcp-server-versions");
        List<String> namespaceList = this.fetchOrderedNamespaceList();
        for (String namespaceId : namespaceList) {
            request.setTenant(namespaceId);
            ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
            if (response.getStatus() != ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_FORMAL) continue;
            McpServerIndexData result = new McpServerIndexData();
            result.setId(id);
            result.setNamespaceId(namespaceId);
            LOGGER.debug("Found MCP server in database: mcpId={}, namespaceId={}", (Object)id, (Object)namespaceId);
            return result;
        }
        LOGGER.debug("MCP server not found in database: mcpId={}", (Object)id);
        return null;
    }

    private McpServerIndexData getMcpServerByNameFromDatabase(String namespaceId, String name) {
        Page<ConfigInfo> serverInfos = this.searchMcpServers(namespaceId, name, "accurate", 1, 1);
        if (CollectionUtils.isNotEmpty((Collection)serverInfos.getPageItems())) {
            ConfigInfo configInfo = (ConfigInfo)serverInfos.getPageItems().get(0);
            McpServerIndexData result = new McpServerIndexData();
            result.setId(configInfo.getDataId().replace("-mcp-versions.json", ""));
            result.setNamespaceId(configInfo.getTenant());
            LOGGER.debug("Found MCP server in database: name={}:{}, mcpId={}", new Object[]{namespaceId, name, result.getId()});
            return result;
        }
        LOGGER.debug("MCP server not found in database: name={}:{}", (Object)namespaceId, (Object)name);
        return null;
    }

    private Page<ConfigInfo> searchMcpServers(String namespace, String serverName, String search, int pageNo, int limit) {
        HashMap<String, String> advanceInfo = new HashMap<String, String>(1);
        if (Objects.isNull(serverName)) {
            serverName = "";
        }
        String dataId = "*";
        if ("blur".equals(search) || serverName.isEmpty()) {
            String nameTag = McpConfigUtils.formatServerNameTagBlurSearchValue(serverName);
            advanceInfo.put("config_tags", nameTag);
            search = "blur";
        } else {
            advanceInfo.put("config_tags", McpConfigUtils.formatServerNameTagAccurateSearchValue(serverName));
            dataId = null;
        }
        return this.configDetailService.findConfigInfoPage(search, pageNo, limit, dataId, "mcp-server-versions", namespace, advanceInfo);
    }

    private McpServerIndexData mapMcpServerVersionConfigToIndexData(ConfigInfo configInfo) {
        McpServerIndexData data = new McpServerIndexData();
        data.setId(configInfo.getDataId().replace("-mcp-versions.json", ""));
        data.setNamespaceId(configInfo.getTenant());
        return data;
    }

    private List<String> fetchOrderedNamespaceList() {
        return this.namespaceOperationService.getNamespaceList().stream().sorted(Comparator.comparing(Namespace::getNamespace)).map(Namespace::getNamespace).toList();
    }

    private void startSyncTask() {
        this.syncTask = this.scheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                LOGGER.debug("Starting cache sync task");
                this.syncCacheFromDatabase();
                LOGGER.debug("Cache sync task completed");
            }
            catch (Exception e) {
                LOGGER.error("Error during cache sync task", (Throwable)e);
            }
        }, this.syncInterval, this.syncInterval, TimeUnit.SECONDS);
        LOGGER.info("Cache sync task started with interval: {}s", (Object)this.syncInterval);
    }

    @PreDestroy
    public void destroy() {
        try {
            if (this.syncTask != null) {
                this.syncTask.cancel(true);
            }
            this.scheduledExecutor.shutdown();
        }
        catch (Exception e) {
            LOGGER.warn("shutting down sync task schedule executor failed", (Throwable)e);
        }
    }

    private void syncCacheFromDatabase() {
        LOGGER.debug("Syncing cache from database");
        List<String> namespaceList = this.fetchOrderedNamespaceList();
        for (String namespaceId : namespaceList) {
            try {
                Page<McpServerIndexData> result = this.searchMcpServerByName(namespaceId, null, "blur", 0, 1000);
                if (result == null || !CollectionUtils.isNotEmpty((Collection)result.getPageItems())) continue;
                for (McpServerIndexData indexData : result.getPageItems()) {
                    this.cacheIndex.updateIndex(namespaceId, indexData.getId(), indexData.getId());
                }
                LOGGER.debug("Synced {} MCP servers for namespace: {}", (Object)result.getPageItems().size(), (Object)namespaceId);
            }
            catch (Exception e) {
                LOGGER.error("Error syncing cache for namespace: {}", (Object)namespaceId, (Object)e);
            }
        }
    }

    public McpCacheIndex.CacheStats getCacheStats() {
        McpCacheIndex.CacheStats stats = this.cacheIndex.getStats();
        LOGGER.debug("Cache stats: hitCount={}, missCount={}, evictionCount={}, size={}, hitRate=%.2f%%", new Object[]{stats.getHitCount(), stats.getMissCount(), stats.getEvictionCount(), stats.getSize(), stats.getHitRate() * 100.0});
        return stats;
    }

    public void clearCache() {
        this.cacheIndex.clear();
        LOGGER.info("Cache cleared");
    }

    public void triggerCacheSync() {
        if (this.cacheEnabled) {
            LOGGER.info("Manual cache sync triggered");
            this.syncCacheFromDatabase();
        } else {
            LOGGER.warn("Cache is disabled, manual sync ignored");
        }
    }

    @Override
    public void removeMcpServerByName(String namespaceId, String mcpName) {
        if (this.cacheEnabled) {
            LOGGER.debug("Removing cache entry by name: namespaceId={}, mcpName={}", (Object)namespaceId, (Object)mcpName);
            this.cacheIndex.removeIndex(namespaceId, mcpName);
        } else {
            LOGGER.debug("Cache is disabled, ignoring cache removal by name: namespaceId={}, mcpName={}", (Object)namespaceId, (Object)mcpName);
        }
    }

    @Override
    public void removeMcpServerById(String mcpId) {
        if (this.cacheEnabled) {
            LOGGER.debug("Removing cache entry by ID: mcpId={}", (Object)mcpId);
            this.cacheIndex.removeIndex(mcpId);
        } else {
            LOGGER.debug("Cache is disabled, ignoring cache removal by ID: mcpId={}", (Object)mcpId);
        }
    }
}

