/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.config;

import com.alibaba.nacos.ai.config.McpCacheIndexProperties;
import com.alibaba.nacos.ai.index.CachedMcpServerIndex;
import com.alibaba.nacos.ai.index.McpCacheIndex;
import com.alibaba.nacos.ai.index.McpServerIndex;
import com.alibaba.nacos.ai.index.MemoryMcpCacheIndex;
import com.alibaba.nacos.ai.index.PlainMcpServerIndex;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={McpCacheIndexProperties.class})
public class McpServerIndexConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpServerIndexConfiguration.class);
    private final McpCacheIndexProperties cacheProperties;

    public McpServerIndexConfiguration(McpCacheIndexProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }

    @Bean
    @ConditionalOnProperty(name={"nacos.mcp.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public McpCacheIndex mcpCacheIndex() {
        LOGGER.info("Creating McpCacheIndex bean with maxSize={}, expireTime={}s, cleanupInterval={}s", new Object[]{this.cacheProperties.getMaxSize(), this.cacheProperties.getExpireTimeSeconds(), this.cacheProperties.getCleanupIntervalSeconds()});
        return new MemoryMcpCacheIndex(this.cacheProperties);
    }

    @Bean
    @ConditionalOnProperty(name={"nacos.mcp.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public ScheduledExecutorService mcpCacheScheduledExecutor() {
        LOGGER.info("Creating ScheduledExecutorService for MCP cache with syncInterval={}s", (Object)this.cacheProperties.getSyncIntervalSeconds());
        return new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r, "mcp-cache-sync");
            t.setDaemon(true);
            return t;
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Bean
    @Primary
    @ConditionalOnProperty(name={"nacos.mcp.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public McpServerIndex cachedMcpServerIndex(ConfigDetailService configDetailService, NamespaceOperationService namespaceOperationService, ConfigQueryChainService configQueryChainService, McpCacheIndex mcpCacheIndex, ScheduledExecutorService mcpCacheScheduledExecutor) {
        LOGGER.info("Creating CachedMcpServerIndex bean with cache enabled");
        return new CachedMcpServerIndex(configDetailService, namespaceOperationService, configQueryChainService, mcpCacheIndex, mcpCacheScheduledExecutor, this.cacheProperties.isEnabled(), this.cacheProperties.getSyncIntervalSeconds());
    }

    @Bean
    @Primary
    @ConditionalOnProperty(name={"nacos.mcp.cache.enabled"}, havingValue="false")
    public McpServerIndex plainMcpServerIndex(ConfigDetailService configDetailService, NamespaceOperationService namespaceOperationService, ConfigQueryChainService configQueryChainService) {
        LOGGER.info("Creating PlainMcpServerIndex bean as cache is disabled");
        return new PlainMcpServerIndex(namespaceOperationService, configDetailService, configQueryChainService);
    }
}

