/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.config;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.filter.NacosPackageExcludeFilter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiEnabledFilter
implements NacosPackageExcludeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiEnabledFilter.class);
    private static final String AI_ENABLED_KEY = "nacos.extension.ai.enabled";

    public String getResponsiblePackagePrefix() {
        return "com.alibaba.nacos.ai";
    }

    public boolean isExcluded(String className, Set<String> annotationNames) {
        boolean aiDisabled;
        String functionMode = EnvUtil.getFunctionMode();
        if (StringUtils.isNotEmpty((String)functionMode)) {
            LOGGER.warn("AI module disabled because function mode is {}, and AI depend naming module and config module both", (Object)functionMode);
            return true;
        }
        boolean bl = aiDisabled = (Boolean)EnvUtil.getProperty((String)AI_ENABLED_KEY, Boolean.class, (Object)true) == false;
        if (aiDisabled) {
            LOGGER.warn("AI module disabled because set {} as false", (Object)AI_ENABLED_KEY);
        }
        return aiDisabled;
    }
}

