/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Service;

@Service
public class McpToolOperationService {
    private final ConfigQueryChainService configQueryChainService;
    private final ConfigOperationService configOperationService;

    public McpToolOperationService(ConfigQueryChainService configQueryChainService, ConfigOperationService configOperationService) {
        this.configQueryChainService = configQueryChainService;
        this.configOperationService = configOperationService;
    }

    public void refreshMcpTool(String namespaceId, String mcpName, McpToolSpecification toolSpecification) throws NacosException {
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        this.configOperationService.publishConfig((ConfigForm)this.buildMcpToolConfigForm(namespaceId, mcpName, toolSpecification), configRequestInfo, null);
    }

    public McpToolSpecification getMcpTool(String namespaceId, String toolsDescriptionRef) throws NacosException {
        ConfigQueryChainRequest request = this.buildQueryMcpToolRequest(namespaceId, toolsDescriptionRef);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND == response.getStatus()) {
            return null;
        }
        return this.transferToMcpServerTool(response);
    }

    public void deleteMcpTool(String namespaceId, String mcpName) throws NacosException {
        this.configOperationService.deleteConfig(mcpName + "-mcp-tools.json", "mcp-tools", namespaceId, null, null, "nacos", null);
    }

    private ConfigFormV3 buildMcpToolConfigForm(String namespaceId, String mcpName, McpToolSpecification toolSpecification) {
        ConfigFormV3 configFormV3 = new ConfigFormV3();
        configFormV3.setGroupName("mcp-tools");
        configFormV3.setGroup("mcp-tools");
        configFormV3.setNamespaceId(namespaceId);
        configFormV3.setDataId(mcpName + "-mcp-tools.json");
        configFormV3.setContent(JacksonUtils.toJson((Object)toolSpecification));
        configFormV3.setType(ConfigType.JSON.getType());
        configFormV3.setAppName(mcpName);
        configFormV3.setSrcUser("nacos");
        return configFormV3;
    }

    private ConfigQueryChainRequest buildQueryMcpToolRequest(String namespaceId, String toolsDescriptionRef) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setDataId(toolsDescriptionRef);
        request.setGroup("mcp-tools");
        request.setTenant(namespaceId);
        return request;
    }

    private McpToolSpecification transferToMcpServerTool(ConfigQueryChainResponse response) {
        return (McpToolSpecification)JacksonUtils.toObj((String)response.getContent(), (TypeReference)new TypeReference<McpToolSpecification>(){});
    }
}

