/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.ai.model.mcp.McpServerStorageInfo;
import com.alibaba.nacos.ai.service.McpEndpointOperationService;
import com.alibaba.nacos.ai.service.McpToolOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpCapability;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class McpServerOperationService {
    private final ConfigQueryChainService configQueryChainService;
    private final ConfigOperationService configOperationService;
    private final ConfigDetailService configDetailService;
    private final McpToolOperationService toolOperationService;
    private final McpEndpointOperationService endpointOperationService;

    public McpServerOperationService(ConfigQueryChainService configQueryChainService, ConfigOperationService configOperationService, ConfigDetailService configDetailService, McpToolOperationService toolOperationService, McpEndpointOperationService endpointOperationService) {
        this.configQueryChainService = configQueryChainService;
        this.configOperationService = configOperationService;
        this.configDetailService = configDetailService;
        this.toolOperationService = toolOperationService;
        this.endpointOperationService = endpointOperationService;
    }

    public Page<McpServerBasicInfo> listMcpServer(String namespaceId, String mcpName, String search, int pageNo, int pageSize) {
        Object targetMcpName;
        if (StringUtils.isBlank((CharSequence)mcpName)) {
            targetMcpName = "*-mcp-server.json";
            search = "blur";
        } else {
            targetMcpName = mcpName + "-mcp-server.json";
        }
        Page mcpServerPage = this.configDetailService.findConfigInfoPage(search, pageNo, pageSize, (String)targetMcpName, "mcp-server", namespaceId, Collections.emptyMap());
        Page result = new Page();
        result.setTotalCount(mcpServerPage.getTotalCount());
        result.setPageNumber(mcpServerPage.getPageNumber());
        result.setPagesAvailable(mcpServerPage.getPagesAvailable());
        for (ConfigInfo each : mcpServerPage.getPageItems()) {
            result.getPageItems().add(this.transferToMcpServerBasicInfo(each));
        }
        return result;
    }

    public McpServerDetailInfo getMcpServer(String namespaceId, String mcpName) throws NacosException {
        ConfigQueryChainRequest request = this.buildQueryMcpServerRequest(namespaceId, mcpName);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND == response.getStatus()) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, String.format("mcp server `%s` not found", mcpName));
        }
        McpServerStorageInfo serverSpecification = (McpServerStorageInfo)((Object)JacksonUtils.toObj((String)response.getContent(), McpServerStorageInfo.class));
        McpServerDetailInfo result = new McpServerDetailInfo();
        BeanUtils.copyProperties((Object)((Object)serverSpecification), (Object)result);
        if (null != serverSpecification.getToolsDescriptionRef()) {
            McpToolSpecification toolSpec = this.toolOperationService.getMcpTool(namespaceId, serverSpecification.getToolsDescriptionRef());
            result.setToolSpec(toolSpec);
        }
        if (!"stdio".equalsIgnoreCase(serverSpecification.getProtocol())) {
            this.injectBackendEndpointRef(result);
        }
        return result;
    }

    private void injectBackendEndpointRef(McpServerDetailInfo detailInfo) throws NacosException {
        List<Instance> instances = this.endpointOperationService.getMcpServerEndpointInstances(detailInfo.getRemoteServerConfig().getServiceRef());
        LinkedList<McpEndpointInfo> backendEndpoints = new LinkedList<McpEndpointInfo>();
        for (Instance each : instances) {
            McpEndpointInfo mcpEndpointInfo = new McpEndpointInfo();
            mcpEndpointInfo.setAddress(each.getIp());
            mcpEndpointInfo.setPort(each.getPort());
            backendEndpoints.add(mcpEndpointInfo);
        }
        detailInfo.setBackendEndpoints(backendEndpoints);
    }

    public void createMcpServer(String namespaceId, String mcpName, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        ConfigQueryChainRequest request = this.buildQueryMcpServerRequest(namespaceId, mcpName);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND != response.getStatus()) {
            throw new NacosApiException(409, ErrorCode.RESOURCE_CONFLICT, String.format("mcp server `%s` has existed, please update it rather than create.", mcpName));
        }
        McpServerStorageInfo newSpecification = new McpServerStorageInfo();
        BeanUtils.copyProperties((Object)serverSpecification, (Object)((Object)newSpecification));
        this.injectToolAndEndpoint(namespaceId, mcpName, newSpecification, toolSpecification, endpointSpecification);
        ConfigFormV3 configForm = this.buildMcpConfigForm(namespaceId, mcpName, newSpecification);
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setUpdateForExist(Boolean.valueOf(false));
        this.configOperationService.publishConfig((ConfigForm)configForm, configRequestInfo, null);
    }

    public void updateMcpServer(String namespaceId, String mcpName, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        ConfigQueryChainRequest request = this.buildQueryMcpServerRequest(namespaceId, mcpName);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND == response.getStatus()) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, String.format("mcp server `%s` not found", mcpName));
        }
        McpServerStorageInfo newSpecification = new McpServerStorageInfo();
        BeanUtils.copyProperties((Object)serverSpecification, (Object)((Object)newSpecification));
        this.injectToolAndEndpoint(namespaceId, mcpName, newSpecification, toolSpecification, endpointSpecification);
        ConfigFormV3 configForm = this.buildMcpConfigForm(namespaceId, mcpName, newSpecification);
        this.configOperationService.publishConfig((ConfigForm)configForm, new ConfigRequestInfo(), null);
    }

    public void deleteMcpServer(String namespaceId, String mcpName) throws NacosException {
        this.toolOperationService.deleteMcpTool(namespaceId, mcpName);
        this.endpointOperationService.deleteMcpServerEndpointService(namespaceId, mcpName);
        this.configOperationService.deleteConfig(mcpName + "-mcp-server.json", "mcp-server", namespaceId, null, null, "nacos", null);
    }

    private void injectToolAndEndpoint(String namespaceId, String mcpName, McpServerStorageInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        serverSpecification.setCapabilities(new LinkedList());
        if (null != toolSpecification && null != toolSpecification.getTools() && !toolSpecification.getTools().isEmpty()) {
            this.toolOperationService.refreshMcpTool(namespaceId, mcpName, toolSpecification);
            serverSpecification.getCapabilities().add(McpCapability.TOOL);
            serverSpecification.setToolsDescriptionRef(mcpName + "-mcp-tools.json");
        }
        if (null != endpointSpecification) {
            com.alibaba.nacos.naming.core.v2.pojo.Service service = this.endpointOperationService.createMcpServerEndpointServiceIfNecessary(namespaceId, mcpName, endpointSpecification);
            McpServiceRef serviceRef = new McpServiceRef();
            serviceRef.setNamespaceId(service.getNamespace());
            serviceRef.setGroupName(service.getGroup());
            serviceRef.setServiceName(service.getName());
            serverSpecification.getRemoteServerConfig().setServiceRef(serviceRef);
        }
    }

    private ConfigFormV3 buildMcpConfigForm(String namespaceId, String mcpName, McpServerBasicInfo serverSpecification) {
        ConfigFormV3 configFormV3 = new ConfigFormV3();
        configFormV3.setGroupName("mcp-server");
        configFormV3.setGroup("mcp-server");
        configFormV3.setNamespaceId(namespaceId);
        configFormV3.setDataId(mcpName + "-mcp-server.json");
        configFormV3.setContent(JacksonUtils.toJson((Object)serverSpecification));
        configFormV3.setType(ConfigType.JSON.getType());
        configFormV3.setAppName(mcpName);
        configFormV3.setSrcUser("nacos");
        return configFormV3;
    }

    private ConfigQueryChainRequest buildQueryMcpServerRequest(String namespaceId, String mcpName) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setDataId(mcpName + "-mcp-server.json");
        request.setGroup("mcp-server");
        request.setTenant(namespaceId);
        return request;
    }

    private McpServerBasicInfo transferToMcpServerBasicInfo(ConfigInfo configInfo) {
        return (McpServerBasicInfo)JacksonUtils.toObj((String)configInfo.getContent(), McpServerBasicInfo.class);
    }
}

