/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence.embedded;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.auth.impl.model.OffsetFetchResult;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthPaginationHelper;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.PageHandlerAdapterFactory;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.DerbyPageHandlerAdapter;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

public class AuthEmbeddedPaginationHelperImpl<E>
implements AuthPaginationHelper<E> {
    private final DatabaseOperate databaseOperate;

    public AuthEmbeddedPaginationHelperImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
    }

    @Override
    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPage(sqlCountRows, sqlFetchRows, args, pageNo, pageSize, (Long)null, rowMapper);
    }

    @Override
    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, Long lastMaxId, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)this.databaseOperate.queryOne(sqlCountRows, args, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt.intValue());
        if (pageNo > pageCount) {
            return page;
        }
        String fetchSql = sqlFetchRows;
        OffsetFetchResult offsetFetchResult = this.addOffsetAndFetchNext(fetchSql, args, pageNo, pageSize);
        fetchSql = offsetFetchResult.getFetchSql();
        args = offsetFetchResult.getNewArgs();
        List result = this.databaseOperate.queryMany(fetchSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public Page<E> fetchPageLimit(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)this.databaseOperate.queryOne(sqlCountRows, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt.intValue());
        if (pageNo > pageCount) {
            return page;
        }
        String fetchSql = sqlFetchRows;
        OffsetFetchResult offsetFetchResult = this.addOffsetAndFetchNext(fetchSql, args, pageNo, pageSize);
        fetchSql = offsetFetchResult.getFetchSql();
        args = offsetFetchResult.getNewArgs();
        List result = this.databaseOperate.queryMany(fetchSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public Page<E> fetchPageLimit(String sqlCountRows, Object[] args1, String sqlFetchRows, Object[] args2, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)this.databaseOperate.queryOne(sqlCountRows, args1, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt.intValue());
        if (pageNo > pageCount) {
            return page;
        }
        String fetchSql = sqlFetchRows;
        OffsetFetchResult offsetFetchResult = this.addOffsetAndFetchNext(fetchSql, args2, pageNo, pageSize);
        fetchSql = offsetFetchResult.getFetchSql();
        args2 = offsetFetchResult.getNewArgs();
        List result = this.databaseOperate.queryMany(fetchSql, args2, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public Page<E> fetchPageLimit(String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Page page = new Page();
        String fetchSql = sqlFetchRows;
        OffsetFetchResult offsetFetchResult = this.addOffsetAndFetchNext(fetchSql, args, pageNo, pageSize);
        fetchSql = offsetFetchResult.getFetchSql();
        args = offsetFetchResult.getNewArgs();
        List result = this.databaseOperate.queryMany(fetchSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public Page fetchPageLimit(MapperResult countMapperResult, MapperResult mapperResult, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPageLimit(countMapperResult.getSql(), countMapperResult.getParamList().toArray(), mapperResult.getSql(), mapperResult.getParamList().toArray(), pageNo, pageSize, rowMapper);
    }

    @Override
    public void updateLimit(String sql, Object[] args) {
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    private OffsetFetchResult addOffsetAndFetchNext(String fetchSql, Object[] arg, int pageNo, int pageSize) {
        return PageHandlerAdapterFactory.getInstance().getHandlerAdapterMap().get(DerbyPageHandlerAdapter.class.getName()).addOffsetAndFetchNext(fetchSql, arg, pageNo, pageSize);
    }
}

