/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthPaginationHelper;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RolePersistService;
import com.alibaba.nacos.plugin.auth.impl.persistence.extrnal.AuthExternalPaginationHelperImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ExternalRolePersistServiceImpl
implements RolePersistService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.persistence");
    private JdbcTemplate jt;
    private String dataSourceType = "";
    private static final String PATTERN_STR = "*";

    @PostConstruct
    protected void init() {
        DataSourceService dataSource = DynamicDataSource.getInstance().getDataSource();
        this.jt = dataSource.getJdbcTemplate();
        this.dataSourceType = dataSource.getDataSourceType();
    }

    @Override
    public Page<RoleInfo> getRoles(int pageNo, int pageSize) {
        AuthPaginationHelper<RoleInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM (SELECT DISTINCT role FROM roles) roles WHERE ";
        String sqlFetchRows = "SELECT role,username FROM roles WHERE ";
        String where = " 1=1 ";
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<RoleInfo> getRolesByUserNameAndRoleName(String username, String role, int pageNo, int pageSize) {
        AuthPaginationHelper<RoleInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM roles ";
        String sqlFetchRows = "SELECT role,username FROM roles ";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username = ? ");
            params.add(username);
        }
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role = ? ");
            params.add(role);
        }
        try {
            return helper.fetchPage(sqlCountRows + String.valueOf(where), sqlFetchRows + String.valueOf(where), params.toArray(), pageNo, pageSize, AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addRole(String role, String userName) {
        String sql = "INSERT INTO roles (role, username) VALUES (?, ?)";
        try {
            this.jt.update(sql, new Object[]{role, userName});
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteRole(String role) {
        String sql = "DELETE FROM roles WHERE role=?";
        try {
            this.jt.update(sql, new Object[]{role});
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteRole(String role, String username) {
        String sql = "DELETE FROM roles WHERE role=? AND username=?";
        try {
            this.jt.update(sql, new Object[]{role, username});
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> findRolesLikeRoleName(String role) {
        String sql = "SELECT role FROM roles WHERE role LIKE ?";
        List users = this.jt.queryForList(sql, (Object[])new String[]{String.format("%%%s%%", role)}, String.class);
        return users;
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public Page<RoleInfo> findRolesLike4Page(String username, String role, int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM roles";
        String sqlFetchRows = "SELECT role, username FROM roles";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username LIKE ? ");
            params.add(this.generateLikeArgument(username));
        }
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role LIKE ? ");
            params.add(this.generateLikeArgument(role));
        }
        AuthPaginationHelper<RoleInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage(sqlCountRows + String.valueOf(where), sqlFetchRows + String.valueOf(where), params.toArray(), pageNo, pageSize, AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public <E> AuthPaginationHelper<E> createPaginationHelper() {
        return new AuthExternalPaginationHelperImpl(this.jt, this.dataSourceType);
    }

    private static final class RoleInfoRowMapper
    implements RowMapper<RoleInfo> {
        private RoleInfoRowMapper() {
        }

        public RoleInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setRole(rs.getString("role"));
            roleInfo.setUsername(rs.getString("username"));
            return roleInfo;
        }
    }
}

