/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthSystemTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManagerDelegate;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordGeneratorUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth", "/v1/auth/users"})
public class UserController {
    private final TokenManagerDelegate jwtTokenManager;
    private final NacosUserService userDetailsService;
    private final NacosRoleService roleService;
    private final AuthConfigs authConfigs;
    private final IAuthenticationManager iAuthenticationManager;
    @Deprecated
    private final AuthenticationManager authenticationManager;

    public UserController(TokenManagerDelegate jwtTokenManager, NacosUserService userDetailsService, NacosRoleService roleService, AuthConfigs authConfigs, IAuthenticationManager iAuthenticationManager, AuthenticationManager authenticationManager) {
        this.jwtTokenManager = jwtTokenManager;
        this.userDetailsService = userDetailsService;
        this.roleService = roleService;
        this.authConfigs = authConfigs;
        this.iAuthenticationManager = iAuthenticationManager;
        this.authenticationManager = authenticationManager;
    }

    @Secured(resource="console/users", action=ActionTypes.WRITE)
    @PostMapping
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="POST ${contextPath:nacos}/v3/auth/user")
    public Object createUser(@RequestParam String username, @RequestParam String password) {
        if ("nacos".equals(username)) {
            return RestResultUtils.failed((int)HttpStatus.CONFLICT.value(), (Object)"User `nacos` is default admin user. Please use `/nacos/v1/auth/users/admin` API to init `nacos` users. Detail see `https://nacos.io/docs/latest/manual/admin/auth/#31-%E8%AE%BE%E7%BD%AE%E7%AE%A1%E7%90%86%E5%91%98%E5%AF%86%E7%A0%81`");
        }
        User user = this.userDetailsService.getUser(username);
        if (user != null) {
            throw new IllegalArgumentException("user '" + username + "' already exist!");
        }
        this.userDetailsService.createUser(username, password);
        return RestResultUtils.success((Object)"create user ok!");
    }

    @PostMapping(value={"/admin"})
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="POST ${contextPath:nacos}/v3/auth/user/admin")
    public Object createAdminUser(@RequestParam(required=false) String password) {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            if (this.iAuthenticationManager.hasGlobalAdminRole()) {
                return RestResultUtils.failed((int)HttpStatus.CONFLICT.value(), (Object)"have admin user cannot use it");
            }
            if (StringUtils.isBlank((CharSequence)password)) {
                password = PasswordGeneratorUtil.generateRandomPassword();
            }
            String username = "nacos";
            this.userDetailsService.createUser(username, password);
            this.roleService.addAdminRole(username);
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            result.put("username", username);
            result.put("password", password);
            return result;
        }
        return RestResultUtils.failed((int)HttpStatus.NOT_IMPLEMENTED.value(), (Object)"not support");
    }

    @DeleteMapping
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="DELETE ${contextPath:nacos}/v3/auth/user")
    public Object deleteUser(@RequestParam String username) {
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!"ROLE_ADMIN".equals(roleInfo.getRole())) continue;
                throw new IllegalArgumentException("cannot delete admin: " + username);
            }
        }
        this.userDetailsService.deleteUser(username);
        return RestResultUtils.success((Object)"delete user ok!");
    }

    @PutMapping
    @Secured(resource="console/user/password", action=ActionTypes.WRITE, tags={"only_identity", "console/user/password"})
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="PUT ${contextPath:nacos}/v3/auth/user")
    public Object updateUser(@RequestParam String username, @RequestParam String newPassword, HttpServletResponse response, HttpServletRequest request) throws IOException {
        try {
            if (!this.hasPermission(username, request)) {
                response.sendError(403, "authorization failed!");
                return null;
            }
        }
        catch (HttpSessionRequiredException e) {
            response.sendError(401, "session expired!");
            return null;
        }
        catch (AccessException exception) {
            response.sendError(403, "authorization failed!");
            return null;
        }
        User user = this.userDetailsService.getUser(username);
        if (user == null) {
            throw new IllegalArgumentException("user " + username + " not exist!");
        }
        this.userDetailsService.updateUserPassword(username, newPassword);
        return RestResultUtils.success((Object)"update user ok!");
    }

    private boolean hasPermission(String username, HttpServletRequest request) throws HttpSessionRequiredException, AccessException {
        if (!this.authConfigs.isAuthEnabled()) {
            return true;
        }
        IdentityContext identityContext = RequestContextHolder.getContext().getAuthContext().getIdentityContext();
        if (identityContext == null) {
            throw new HttpSessionRequiredException("session expired!");
        }
        NacosUser user = (NacosUser)identityContext.getParameter("nacosuser");
        if (user == null) {
            user = this.iAuthenticationManager.authenticate(request);
            if (user == null) {
                throw new HttpSessionRequiredException("session expired!");
            }
            this.iAuthenticationManager.hasGlobalAdminRole(user);
        }
        if (user.isGlobalAdmin()) {
            return true;
        }
        return user.getUserName().equals(username);
    }

    @GetMapping(params={"search=accurate"})
    @Secured(resource="console/users", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/user/list")
    public Page<User> getUsers(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", required=false, defaultValue="") String username) {
        return this.userDetailsService.getUsers(pageNo, pageSize, username);
    }

    @GetMapping(params={"search=blur"})
    @Secured(resource="console/users", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/user/list")
    public Page<User> fuzzySearchUser(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", required=false, defaultValue="") String username) {
        return this.userDetailsService.findUsers(username, pageNo, pageSize);
    }

    @PostMapping(value={"/login"})
    @Compatibility(apiType=ApiType.OPEN_API, alternatives="POST ${contextPath:nacos}/v3/auth/user/login")
    public Object login(@RequestParam String username, @RequestParam String password, HttpServletResponse response, HttpServletRequest request) throws AccessException, IOException {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType()) || AuthSystemTypes.LDAP.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            NacosUser user = this.iAuthenticationManager.authenticate(request);
            response.addHeader("Authorization", "Bearer " + user.getToken());
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            result.put("accessToken", user.getToken());
            result.put("tokenTtl", this.jwtTokenManager.getTokenTtlInSeconds(user.getToken()));
            result.put("globalAdmin", this.iAuthenticationManager.hasGlobalAdminRole(user));
            result.put("username", user.getUserName());
            return result;
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            String token = this.jwtTokenManager.createToken(authentication);
            response.addHeader("Authorization", "Bearer " + token);
            return RestResultUtils.success((Object)("Bearer " + token));
        }
        catch (BadCredentialsException authentication) {
            return RestResultUtils.failed((int)HttpStatus.UNAUTHORIZED.value(), null, (String)"Login failed");
        }
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/user/search")
    public List<String> searchUsersLikeUsername(@RequestParam String username) {
        return this.userDetailsService.findUserNames(username);
    }
}

