/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth/permissions"})
public class PermissionController {
    private final NacosRoleService nacosRoleService;

    public PermissionController(NacosRoleService nacosRoleService) {
        this.nacosRoleService = nacosRoleService;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/permission/list")
    public Object getPermissions(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="role", defaultValue="") String role) {
        return this.nacosRoleService.getPermissions(role, pageNo, pageSize);
    }

    @GetMapping(params={"search=blur"})
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/permission/list")
    public Page<PermissionInfo> fuzzySearchPermission(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="role", defaultValue="") String role) {
        return this.nacosRoleService.findPermissions(role, pageNo, pageSize);
    }

    @PostMapping
    @Secured(resource="console/permissions", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="POST ${contextPath:nacos}/v3/auth/permission")
    public Object addPermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        this.nacosRoleService.addPermission(role, resource, action);
        return RestResultUtils.success((Object)"add permission ok!");
    }

    @DeleteMapping
    @Secured(resource="console/permissions", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="DELETE ${contextPath:nacos}/v3/auth/permission")
    public Object deletePermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        this.nacosRoleService.deletePermission(role, resource, action);
        return RestResultUtils.success((Object)"delete permission ok!");
    }

    @GetMapping
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/permission")
    public Result<Boolean> isDuplicatePermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        return this.nacosRoleService.isDuplicatePermission(role, resource, action);
    }
}

