/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.roles;

import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.AbstractCachedRoleService;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public abstract class AbstractCheckedRoleService
extends AbstractCachedRoleService
implements NacosRoleService {
    private final AuthConfigs authConfigs;

    protected AbstractCheckedRoleService(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
    }

    @Override
    public boolean hasPermission(NacosUser nacosUser, Permission permission) {
        if (this.isUpdatePasswordPermission(permission)) {
            return true;
        }
        List<RoleInfo> roleInfoList = this.getRoles(nacosUser.getUserName());
        if (CollectionUtils.isEmpty(roleInfoList)) {
            return false;
        }
        for (RoleInfo roleInfo : roleInfoList) {
            if (!"ROLE_ADMIN".equals(roleInfo.getRole())) continue;
            nacosUser.setGlobalAdmin(true);
            return true;
        }
        if (permission.getResource().getName().startsWith("console/")) {
            return false;
        }
        for (RoleInfo roleInfo : roleInfoList) {
            List<PermissionInfo> permissionInfoList = this.getPermissions(roleInfo.getRole());
            if (CollectionUtils.isEmpty(permissionInfoList)) continue;
            for (PermissionInfo permissionInfo : permissionInfoList) {
                String permissionAction;
                Object permissionResource = permissionInfo.getResource().replaceAll("\\*", ".*");
                if (((String)permissionResource).startsWith(":")) {
                    permissionResource = "public" + (String)permissionResource;
                }
                if (!(permissionAction = permissionInfo.getAction()).contains(permission.getAction()) || !Pattern.matches((String)permissionResource, this.joinResource(permission.getResource()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Result<Boolean> isDuplicatePermission(String role, String resource, String action) {
        List<PermissionInfo> permissionInfos = this.getPermissions(role);
        if (CollectionUtils.isEmpty(permissionInfos)) {
            return Result.success((Object)Boolean.FALSE);
        }
        for (PermissionInfo permissionInfo : permissionInfos) {
            boolean actionMatch;
            boolean resourceMatch = StringUtils.equals((String)resource, (String)permissionInfo.getResource());
            boolean bl = actionMatch = StringUtils.equals((String)action, (String)permissionInfo.getAction()) || "rw".equals(permissionInfo.getAction());
            if (!resourceMatch || !actionMatch) continue;
            return Result.success((Object)Boolean.TRUE);
        }
        return Result.success((Object)Boolean.FALSE);
    }

    @Override
    public boolean hasGlobalAdminRole(String userName) {
        List<RoleInfo> roles = this.getRoles(userName);
        return roles.stream().anyMatch(roleInfo -> "ROLE_ADMIN".equals(roleInfo.getRole()));
    }

    @Override
    public boolean hasGlobalAdminRole() {
        if (this.authConfigs.isHasGlobalAdminRole()) {
            return true;
        }
        List<RoleInfo> roles = this.getAllRoles();
        boolean hasGlobalAdminRole = CollectionUtils.isNotEmpty(roles) && roles.stream().anyMatch(roleInfo -> "ROLE_ADMIN".equals(roleInfo.getRole()));
        this.authConfigs.setHasGlobalAdminRole(hasGlobalAdminRole);
        return hasGlobalAdminRole;
    }

    private boolean isUpdatePasswordPermission(Permission permission) {
        Properties properties = permission.getResource().getProperties();
        return null != properties && properties.contains("console/user/password");
    }

    private String joinResource(Resource resource) {
        if ("specified".equals(resource.getType())) {
            return resource.getName();
        }
        StringBuilder result = new StringBuilder();
        String namespaceId = resource.getNamespaceId();
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        result.append(namespaceId);
        String group = resource.getGroup();
        if (StringUtils.isBlank((CharSequence)group)) {
            result.append(":").append('*');
        } else {
            result.append(":").append(group);
        }
        String resourceName = resource.getName();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            result.append(":").append(resource.getType().toLowerCase()).append("/*");
        } else {
            result.append(":").append(resource.getType().toLowerCase()).append('/').append(resourceName);
        }
        return result.toString();
    }
}

