/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthPaginationHelper;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionPersistService;
import com.alibaba.nacos.plugin.auth.impl.persistence.embedded.AuthEmbeddedPaginationHelperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmbeddedPermissionPersistServiceImpl
implements PermissionPersistService {
    private final DatabaseOperate databaseOperate;
    private static final String PATTERN_STR = "*";
    private static final String SQL_DERBY_ESCAPE_BACK_SLASH_FOR_LIKE = " ESCAPE '\\' ";

    public EmbeddedPermissionPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
    }

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        AuthPaginationHelper<PermissionInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions WHERE ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions WHERE ";
        String where = " role= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((String)role)) {
            params = Collections.singletonList(role);
        } else {
            where = " 1=1 ";
        }
        Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, AuthRowMapperManager.PERMISSION_ROW_MAPPER);
        if (pageInfo == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        String sql = "INSERT INTO permissions (role, resource, action) VALUES (?, ?, ?)";
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])new Object[]{role, resource, action});
        this.databaseOperate.blockUpdate();
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        String sql = "DELETE FROM permissions WHERE role=? AND resource=? AND action=?";
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])new Object[]{role, resource, action});
        this.databaseOperate.blockUpdate();
    }

    @Override
    public Page<PermissionInfo> findPermissionsLike4Page(String role, int pageNo, int pageSize) {
        Page pageInfo;
        AuthPaginationHelper<PermissionInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions ";
        StringBuilder where = new StringBuilder(" WHERE 1=1");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role LIKE ?");
            where.append(SQL_DERBY_ESCAPE_BACK_SLASH_FOR_LIKE);
            params.add(this.generateLikeArgument(role));
        }
        if ((pageInfo = helper.fetchPage(sqlCountRows + String.valueOf(where), sqlFetchRows + String.valueOf(where), params.toArray(), pageNo, pageSize, AuthRowMapperManager.PERMISSION_ROW_MAPPER)) == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public <E> AuthPaginationHelper<E> createPaginationHelper() {
        return new AuthEmbeddedPaginationHelperImpl(this.databaseOperate);
    }
}

