/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.jwt;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.jwt.NacosJwtPayload;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;

public final class NacosSignatureAlgorithm {
    private static final String JWT_SEPERATOR = ".";
    private static final int HEADER_POSITION = 0;
    private static final int PAYLOAD_POSITION = 1;
    private static final int SIGNATURE_POSITION = 2;
    private static final int JWT_PARTS = 3;
    private static final String HS256_JWT_HEADER = "eyJhbGciOiJIUzI1NiJ9";
    private static final String HS384_JWT_HEADER = "eyJhbGciOiJIUzM4NCJ9";
    private static final String HS512_JWT_HEADER = "eyJhbGciOiJIUzUxMiJ9";
    private static final Base64.Encoder URL_BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder URL_BASE64_DECODER = Base64.getUrlDecoder();
    private static final Map<String, NacosSignatureAlgorithm> MAP = new HashMap<String, NacosSignatureAlgorithm>(4);
    public static final NacosSignatureAlgorithm HS256 = new NacosSignatureAlgorithm("HS256", "HmacSHA256", "eyJhbGciOiJIUzI1NiJ9");
    public static final NacosSignatureAlgorithm HS384 = new NacosSignatureAlgorithm("HS384", "HmacSHA384", "eyJhbGciOiJIUzM4NCJ9");
    public static final NacosSignatureAlgorithm HS512 = new NacosSignatureAlgorithm("HS512", "HmacSHA512", "eyJhbGciOiJIUzUxMiJ9");
    private final String algorithm;
    private final String jcaName;
    private final String header;

    public static NacosUser verify(String jwt, Key key) throws AccessException {
        if (StringUtils.isBlank((CharSequence)jwt)) {
            throw new AccessException("user not found!");
        }
        String[] split = jwt.split("\\.");
        if (split.length != 3) {
            throw new AccessException("token invalid!");
        }
        String header = split[0];
        String payload = split[1];
        String signature = split[2];
        NacosSignatureAlgorithm signatureAlgorithm = MAP.get(header);
        if (signatureAlgorithm == null) {
            throw new AccessException("unsupported signature algorithm");
        }
        NacosUser user = signatureAlgorithm.verify(header, payload, signature, key);
        user.setToken(jwt);
        return user;
    }

    public NacosUser verify(String header, String payload, String signature, Key key) throws AccessException {
        Mac macInstance = this.getMacInstance(key);
        byte[] bytes = macInstance.doFinal((header + JWT_SEPERATOR + payload).getBytes(StandardCharsets.US_ASCII));
        if (!URL_BASE64_ENCODER.encodeToString(bytes).equals(signature)) {
            throw new AccessException("Invalid signature");
        }
        NacosJwtPayload nacosJwtPayload = (NacosJwtPayload)JacksonUtils.toObj((byte[])URL_BASE64_DECODER.decode(payload), NacosJwtPayload.class);
        if (nacosJwtPayload.getExp() >= TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())) {
            return new NacosUser(nacosJwtPayload.getSub());
        }
        throw new AccessException("token expired!");
    }

    public static long getExpiredTimeInSeconds(String jwt, Key key) throws AccessException {
        if (StringUtils.isBlank((CharSequence)jwt)) {
            throw new AccessException("user not found!");
        }
        String[] split = jwt.split("\\.");
        if (split.length != 3) {
            throw new AccessException("token invalid!");
        }
        String header = split[0];
        String payload = split[1];
        String signature = split[2];
        NacosSignatureAlgorithm signatureAlgorithm = MAP.get(header);
        if (signatureAlgorithm == null) {
            throw new AccessException("unsupported signature algorithm");
        }
        return signatureAlgorithm.getExpireTimeInSeconds(header, payload, signature, key);
    }

    public long getExpireTimeInSeconds(String header, String payload, String signature, Key key) throws AccessException {
        Mac macInstance = this.getMacInstance(key);
        byte[] bytes = macInstance.doFinal((header + JWT_SEPERATOR + payload).getBytes(StandardCharsets.US_ASCII));
        if (!URL_BASE64_ENCODER.encodeToString(bytes).equals(signature)) {
            throw new AccessException("Invalid signature");
        }
        NacosJwtPayload nacosJwtPayload = (NacosJwtPayload)JacksonUtils.toObj((byte[])URL_BASE64_DECODER.decode(payload), NacosJwtPayload.class);
        return nacosJwtPayload.getExp();
    }

    private NacosSignatureAlgorithm(String alg, String jcaName, String header) {
        this.algorithm = alg;
        this.jcaName = jcaName;
        this.header = header;
    }

    String sign(NacosJwtPayload nacosJwtPayload, Key key) {
        String jwtWithoutSign = this.header + JWT_SEPERATOR + URL_BASE64_ENCODER.encodeToString(nacosJwtPayload.toString().getBytes(StandardCharsets.UTF_8));
        Mac macInstance = this.getMacInstance(key);
        byte[] bytes = jwtWithoutSign.getBytes(StandardCharsets.US_ASCII);
        String signature = URL_BASE64_ENCODER.encodeToString(macInstance.doFinal(bytes));
        return jwtWithoutSign + JWT_SEPERATOR + signature;
    }

    private Mac getMacInstance(Key key) {
        try {
            Mac instance = Mac.getInstance(this.jcaName);
            instance.init(key);
            return instance;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No Such Algorithm: " + this.jcaName);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getJcaName() {
        return this.jcaName;
    }

    public String getHeader() {
        return this.header;
    }

    static {
        MAP.put(HS256_JWT_HEADER, HS256);
        MAP.put(HS384_JWT_HEADER, HS384);
        MAP.put(HS512_JWT_HEADER, HS512);
    }
}

