/*
 * Decompiled with CFR 0.152.
 */
package feign.form.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.UnexpectedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class PojoUtil {
    public static boolean isUserPojo(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        Class<?> type = object.getClass();
        String packageName = type.getPackage().getName();
        return !packageName.startsWith("java.");
    }

    public static Map<String, Object> toMap(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> type = object.getClass();
        SetAccessibleAction setAccessibleAction = new SetAccessibleAction();
        for (Field field : type.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            setAccessibleAction.setField(field);
            AccessController.doPrivileged(setAccessibleAction);
            Object fieldValue = field.get(object);
            if (fieldValue == null) continue;
            result.put(field.getName(), fieldValue);
        }
        return result;
    }

    private PojoUtil() throws UnexpectedException {
        throw new UnexpectedException("It is not allowed to instantiate this class");
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Object> {
        @Nullable
        private Field field;

        @Override
        public Object run() {
            this.field.setAccessible(true);
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        public void setField(@Nullable Field field) {
            this.field = field;
        }

        @SuppressFBWarnings(justification="generated code")
        public SetAccessibleAction() {
        }
    }
}

