/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static Object getFieldVal(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return field.get(obj);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object getStaticFieldVal(Class<?> cls, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        for (Class<?> classOrSuperclass = cls; classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
            try {
                Field field = classOrSuperclass.getDeclaredField(fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, new Class[0]);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, argType);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, arg);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, argType);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, arg);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String modifiersToString(int modifiers, boolean isMethod) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 1) != 0) {
            buf.append("public");
        } else if ((modifiers & 4) != 0) {
            buf.append("protected");
        } else if ((modifiers & 2) != 0) {
            buf.append("private");
        }
        if ((modifiers & 8) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("static");
        }
        if ((modifiers & 0x400) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("abstract");
        }
        if ((modifiers & 0x20) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synchronized");
        }
        if (!isMethod && (modifiers & 0x80) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("transient");
        } else if ((modifiers & 0x40) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (!isMethod) {
                buf.append("volatile");
            } else {
                buf.append("bridge");
            }
        }
        if ((modifiers & 0x10) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("final");
        }
        if ((modifiers & 0x100) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("native");
        }
        return buf.toString();
    }

    private static boolean parseIdentifier(StringAndPosition str, char separator, char separatorReplace, StringBuilder buf) throws ParseException {
        boolean consumedChar = false;
        while (str.hasMore()) {
            char c = str.peek();
            if (c == separator) {
                buf.append(separatorReplace);
                str.next();
                consumedChar = true;
                continue;
            }
            if (c == ';' || c == '[' || c == '<' || c == '>' || c == ':' || c == '/' || c == '.') break;
            buf.append(c);
            str.next();
            consumedChar = true;
        }
        return consumedChar;
    }

    private static boolean parseIdentifier(StringAndPosition str, StringBuilder buf) throws ParseException {
        return ReflectionUtils.parseIdentifier(str, '\u0000', '\u0000', buf);
    }

    private static boolean parseBaseType(StringAndPosition str, StringBuilder buf) {
        switch (str.peek()) {
            case 'B': {
                buf.append("byte");
                str.next();
                return true;
            }
            case 'C': {
                buf.append("char");
                str.next();
                return true;
            }
            case 'D': {
                buf.append("double");
                str.next();
                return true;
            }
            case 'F': {
                buf.append("float");
                str.next();
                return true;
            }
            case 'I': {
                buf.append("int");
                str.next();
                return true;
            }
            case 'J': {
                buf.append("long");
                str.next();
                return true;
            }
            case 'S': {
                buf.append("short");
                str.next();
                return true;
            }
            case 'Z': {
                buf.append("boolean");
                str.next();
                return true;
            }
            case 'V': {
                buf.append("void");
                str.next();
                return true;
            }
        }
        return false;
    }

    private static boolean parseJavaTypeSignature(StringAndPosition str, StringBuilder buf) throws ParseException {
        return ReflectionUtils.parseReferenceTypeSignature(str, buf) || ReflectionUtils.parseBaseType(str, buf);
    }

    private static boolean parseArrayTypeSignature(StringAndPosition str, StringBuilder buf) throws ParseException {
        int numArrayDims = 0;
        while (str.peek() == '[') {
            ++numArrayDims;
            str.next();
        }
        if (numArrayDims > 0) {
            if (!ReflectionUtils.parseJavaTypeSignature(str, buf)) {
                throw new IllegalArgumentException("Malformatted Java type signature");
            }
            for (int i = 0; i < numArrayDims; ++i) {
                buf.append("[]");
            }
            return true;
        }
        return false;
    }

    private static boolean parseTypeVariableSignature(StringAndPosition str, StringBuilder buf) throws ParseException {
        char peek = str.peek();
        if (peek == 'T') {
            str.next();
            boolean gotIdent = ReflectionUtils.parseIdentifier(str, buf);
            str.expect(';');
            return gotIdent;
        }
        return false;
    }

    private static boolean parseTypeArgument(StringAndPosition str, StringBuilder buf) throws ParseException {
        char peek = str.peek();
        if (peek == '*') {
            str.next();
            buf.append("?");
            return true;
        }
        if (peek == '+') {
            str.next();
            buf.append("? extends ");
            return ReflectionUtils.parseReferenceTypeSignature(str, buf);
        }
        if (peek == '-') {
            str.next();
            buf.append("? super ");
            return ReflectionUtils.parseReferenceTypeSignature(str, buf);
        }
        return ReflectionUtils.parseReferenceTypeSignature(str, buf);
    }

    private static boolean parseClassTypeSignature(StringAndPosition str, StringBuilder buf) throws ParseException {
        if (str.peek() == 'L') {
            str.next();
            if (str.peekMatches("java/lang/") || str.peekMatches("java/util/")) {
                str.advance(10);
            }
            if (!ReflectionUtils.parseIdentifier(str, '/', '.', buf)) {
                throw new IllegalArgumentException("Malformed class name");
            }
            if (str.peek() == '<') {
                buf.append(str.getc());
                boolean isFirstTypeArg = true;
                while (str.peek() != '>') {
                    if (!isFirstTypeArg) {
                        buf.append(", ");
                    }
                    if (!ReflectionUtils.parseTypeArgument(str, buf)) {
                        throw new IllegalArgumentException("Bad type argument");
                    }
                    isFirstTypeArg = false;
                }
                buf.append(str.getc());
            }
            while (str.peek() == '.') {
                buf.append(str.getc());
                ReflectionUtils.parseIdentifier(str, buf);
            }
            str.expect(';');
            return true;
        }
        return false;
    }

    private static boolean parseReferenceTypeSignature(StringAndPosition str, StringBuilder buf) throws ParseException {
        return ReflectionUtils.parseClassTypeSignature(str, buf) || ReflectionUtils.parseTypeVariableSignature(str, buf) || ReflectionUtils.parseArrayTypeSignature(str, buf);
    }

    public static List<String> parseComplexTypeDescriptor(String typeDescriptor) {
        StringAndPosition str = new StringAndPosition(typeDescriptor);
        try {
            StringBuilder buf = new StringBuilder();
            ArrayList<String> typeParts = new ArrayList<String>();
            while (str.hasMore()) {
                char peek = str.peek();
                if (peek == '(' || peek == ')') {
                    str.next();
                    continue;
                }
                if (!ReflectionUtils.parseJavaTypeSignature(str, buf)) {
                    throw new ParseException();
                }
                typeParts.add(buf.toString());
                buf.setLength(0);
            }
            return typeParts;
        }
        catch (Exception e) {
            throw new RuntimeException("Type signature could not be parsed: " + str, e);
        }
    }

    public static String parseSimpleTypeDescriptor(String typeDescriptor) {
        String typeStr;
        StringAndPosition str = new StringAndPosition(typeDescriptor);
        char peek = str.peek();
        if (peek == '(') {
            throw new RuntimeException("Got unexpected method signature");
        }
        try {
            StringBuilder buf = new StringBuilder();
            if (!ReflectionUtils.parseJavaTypeSignature(str, buf)) {
                throw new ParseException();
            }
            typeStr = buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Type signature could not be parsed: " + str, e);
        }
        if (str.hasMore()) {
            throw new RuntimeException("Unused characters in type signature: " + str);
        }
        return typeStr;
    }

    private static Class<?> arrayify(Class<?> cls, int arrayDims) {
        if (arrayDims == 0) {
            return cls;
        }
        int[] zeroes = (int[])Array.newInstance(Integer.TYPE, arrayDims);
        return Array.newInstance(cls, zeroes).getClass();
    }

    public static Class<?> typeStrToClass(String typeStr, ScanResult scanResult) throws IllegalArgumentException {
        String bareType;
        int end = typeStr.length();
        int arrayDims = 0;
        while (end >= 2 && typeStr.charAt(end - 2) == '[' && typeStr.charAt(end - 1) == ']') {
            end -= 2;
            ++arrayDims;
        }
        int typeParamIdx = typeStr.indexOf(60);
        if (typeParamIdx > 0) {
            end = Math.min(end, typeParamIdx);
        }
        switch (bareType = typeStr.substring(0, end)) {
            case "byte": {
                return ReflectionUtils.arrayify(Byte.TYPE, arrayDims);
            }
            case "char": {
                return ReflectionUtils.arrayify(Character.TYPE, arrayDims);
            }
            case "double": {
                return ReflectionUtils.arrayify(Double.TYPE, arrayDims);
            }
            case "float": {
                return ReflectionUtils.arrayify(Float.TYPE, arrayDims);
            }
            case "int": {
                return ReflectionUtils.arrayify(Integer.TYPE, arrayDims);
            }
            case "long": {
                return ReflectionUtils.arrayify(Long.TYPE, arrayDims);
            }
            case "short": {
                return ReflectionUtils.arrayify(Short.TYPE, arrayDims);
            }
            case "boolean": {
                return ReflectionUtils.arrayify(Boolean.TYPE, arrayDims);
            }
            case "void": {
                return ReflectionUtils.arrayify(Void.TYPE, arrayDims);
            }
        }
        int dotIdx = bareType.indexOf(46);
        if (dotIdx < 0) {
            try {
                return ReflectionUtils.arrayify(Class.forName("java.lang." + bareType), arrayDims);
            }
            catch (Exception exception) {
                try {
                    return ReflectionUtils.arrayify(Class.forName("java.util." + bareType), arrayDims);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return ReflectionUtils.arrayify(scanResult.classNameToClassRef(bareType), arrayDims);
    }

    private static class StringAndPosition {
        String string;
        int position;

        public StringAndPosition(String string) {
            this.string = string;
        }

        public char getc() {
            if (this.position >= this.string.length()) {
                return '\u0000';
            }
            return this.string.charAt(this.position++);
        }

        public char peek() {
            return this.string.charAt(this.position);
        }

        public boolean peekMatches(String strMatch) {
            return this.string.regionMatches(this.position, strMatch, 0, strMatch.length());
        }

        public void next() {
            ++this.position;
        }

        public void advance(int n) {
            this.position += n;
        }

        public String toString() {
            return this.string + " (position: " + this.position + ")";
        }

        public boolean hasMore() {
            return this.position < this.string.length();
        }

        public void expect(char c) {
            char next = this.getc();
            if (next != c) {
                throw new IllegalArgumentException("Got character '" + (char)next + "', expected '" + c + "' in string: " + this);
            }
        }
    }

    private static class ParseException
    extends Exception {
        private ParseException() {
        }
    }
}

