/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Join;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassInfoUnlinked {
    String className;
    private final int classModifiers;
    private final boolean isInterface;
    private final boolean isAnnotation;
    private String superclassName;
    private List<String> implementedInterfaces;
    private List<AnnotationInfo> classAnnotations;
    private List<AnnotationInfo> methodAnnotations;
    private List<AnnotationInfo> fieldAnnotations;
    private Set<String> fieldTypes;
    private Map<String, Object> staticFinalFieldValues;
    private String fullyQualifiedContainingMethodName;
    private List<AbstractMap.SimpleEntry<String, String>> classContainmentEntries;
    List<AnnotationInfo.AnnotationParamValue> annotationParamDefaultValues;
    private final ClasspathElement classpathElement;
    List<FieldInfo> fieldInfoList;
    List<MethodInfo> methodInfoList;
    private final ConcurrentHashMap<String, String> stringInternMap;

    private String intern(String string) {
        if (string == null) {
            return null;
        }
        String oldValue = this.stringInternMap.putIfAbsent(string, string);
        return oldValue == null ? string : oldValue;
    }

    ClassInfoUnlinked(String className, int classModifiers, boolean isInterface, boolean isAnnotation, ConcurrentHashMap<String, String> stringInternMap, ClasspathElement classpathElement) {
        this.stringInternMap = stringInternMap;
        this.className = this.intern(className);
        this.classModifiers = classModifiers;
        this.isInterface = isInterface;
        this.isAnnotation = isAnnotation;
        this.classpathElement = classpathElement;
    }

    void addSuperclass(String superclassName) {
        this.superclassName = this.intern(superclassName);
    }

    void addImplementedInterface(String interfaceName) {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = new ArrayList<String>();
        }
        this.implementedInterfaces.add(this.intern(interfaceName));
    }

    void addClassAnnotation(AnnotationInfo classAnnotation) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new ArrayList<AnnotationInfo>();
        }
        this.classAnnotations.add(classAnnotation);
    }

    void addMethodAnnotation(AnnotationInfo methodAnnotation) {
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new ArrayList<AnnotationInfo>();
        }
        this.methodAnnotations.add(methodAnnotation);
    }

    void addFieldAnnotation(AnnotationInfo fieldAnnotation) {
        if (this.fieldAnnotations == null) {
            this.fieldAnnotations = new ArrayList<AnnotationInfo>();
        }
        this.fieldAnnotations.add(fieldAnnotation);
    }

    void addFieldType(String fieldTypeName) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new HashSet<String>();
        }
        this.fieldTypes.add(this.intern(fieldTypeName));
    }

    void addFieldConstantValue(String fieldName, Object staticFinalFieldValue) {
        if (this.staticFinalFieldValues == null) {
            this.staticFinalFieldValues = new HashMap<String, Object>();
        }
        this.staticFinalFieldValues.put(this.intern(fieldName), staticFinalFieldValue);
    }

    void addFieldInfo(FieldInfo fieldInfo) {
        if (this.fieldInfoList == null) {
            this.fieldInfoList = new ArrayList<FieldInfo>();
        }
        this.fieldInfoList.add(fieldInfo);
    }

    void addMethodInfo(MethodInfo methodInfo) {
        if (this.methodInfoList == null) {
            this.methodInfoList = new ArrayList<MethodInfo>();
        }
        this.methodInfoList.add(methodInfo);
    }

    public void addEnclosingMethod(String fullyQualifiedContainingMethodName) {
        this.fullyQualifiedContainingMethodName = fullyQualifiedContainingMethodName;
    }

    public void addClassContainment(String innerClassName, String outerClassName) {
        if (this.classContainmentEntries == null) {
            this.classContainmentEntries = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        }
        this.classContainmentEntries.add(new AbstractMap.SimpleEntry<String, String>(innerClassName, outerClassName));
    }

    public void addAnnotationParamDefaultValues(List<AnnotationInfo.AnnotationParamValue> annotationParamDefaultValues) {
        this.annotationParamDefaultValues = annotationParamDefaultValues;
    }

    void link(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo, LogNode log) {
        ClassInfo classInfo = ClassInfo.addScannedClass(this.className, this.classModifiers, this.isInterface, this.isAnnotation, scanSpec, classNameToClassInfo, this.classpathElement, log);
        if (this.superclassName != null) {
            classInfo.addSuperclass(this.superclassName, classNameToClassInfo);
        }
        if (this.implementedInterfaces != null) {
            for (String string : this.implementedInterfaces) {
                classInfo.addImplementedInterface(string, classNameToClassInfo);
            }
        }
        if (this.classAnnotations != null) {
            for (AnnotationInfo annotationInfo : this.classAnnotations) {
                classInfo.addClassAnnotation(annotationInfo, classNameToClassInfo);
            }
        }
        if (this.methodAnnotations != null) {
            for (AnnotationInfo annotationInfo : this.methodAnnotations) {
                classInfo.addMethodAnnotation(annotationInfo, classNameToClassInfo);
            }
        }
        if (this.fieldAnnotations != null) {
            for (AnnotationInfo annotationInfo : this.fieldAnnotations) {
                classInfo.addFieldAnnotation(annotationInfo, classNameToClassInfo);
            }
        }
        if (this.fieldTypes != null) {
            for (String string : this.fieldTypes) {
                classInfo.addFieldType(string, classNameToClassInfo);
            }
        }
        if (this.staticFinalFieldValues != null) {
            for (Map.Entry entry : this.staticFinalFieldValues.entrySet()) {
                classInfo.addStaticFinalFieldConstantInitializerValue((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.classContainmentEntries != null) {
            ClassInfo.addClassContainment(this.classContainmentEntries, scanSpec, classNameToClassInfo);
        }
        if (this.annotationParamDefaultValues != null) {
            classInfo.addAnnotationParamDefaultValues(this.annotationParamDefaultValues);
        }
        if (this.fullyQualifiedContainingMethodName != null) {
            classInfo.addFullyQualifiedContainingMethodName(this.fullyQualifiedContainingMethodName);
        }
        if (this.fieldInfoList != null) {
            classInfo.addFieldInfo(this.fieldInfoList, classNameToClassInfo);
        }
        if (this.methodInfoList != null) {
            classInfo.addMethodInfo(this.methodInfoList, classNameToClassInfo);
        }
    }

    void logTo(LogNode log) {
        if (log != null) {
            LogNode subLog = log.log("Found " + (this.isAnnotation ? "annotation class" : (this.isInterface ? "interface class" : "class")) + " " + this.className);
            if (this.superclassName != null) {
                subLog.log("Super" + (this.isInterface && !this.isAnnotation ? "interface" : "class") + ": " + this.superclassName);
            }
            if (this.implementedInterfaces != null) {
                subLog.log("Interfaces: " + Join.join(", ", this.implementedInterfaces));
            }
            if (this.classAnnotations != null) {
                subLog.log("Class annotations: " + Join.join(", ", this.classAnnotations));
            }
            if (this.methodAnnotations != null) {
                subLog.log("Method annotations: " + Join.join(", ", this.methodAnnotations));
            }
            if (this.fieldAnnotations != null) {
                subLog.log("Field annotations: " + Join.join(", ", this.fieldAnnotations));
            }
            if (this.fieldTypes != null) {
                subLog.log("Field types: " + Join.join(", ", this.fieldTypes));
            }
            if (this.staticFinalFieldValues != null) {
                ArrayList<String> fieldInitializers = new ArrayList<String>();
                for (Map.Entry<String, Object> ent : this.staticFinalFieldValues.entrySet()) {
                    fieldInitializers.add(ent.getKey() + " = " + ent.getValue());
                }
                subLog.log("Static final field values: " + Join.join(", ", fieldInitializers));
            }
        }
    }
}

