/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;

public class FieldInfo {
    private final String fieldName;
    private final int modifiers;
    private final String typeStr;
    private final Object constValue;
    private final List<String> annotationNames;

    public FieldInfo(String fieldName, int modifiers, String typeDescriptor, Object constValue, List<String> annotationNames) {
        this.fieldName = fieldName;
        this.modifiers = modifiers;
        List<String> typeNames = ReflectionUtils.parseTypeDescriptor(typeDescriptor);
        if (typeNames.size() != 1) {
            throw new IllegalArgumentException("Invalid type descriptor for field: " + typeDescriptor);
        }
        this.typeStr = typeNames.get(0);
        this.constValue = constValue;
        this.annotationNames = annotationNames.isEmpty() ? Collections.emptyList() : annotationNames;
    }

    public String getModifiers() {
        return ReflectionUtils.modifiersToString(this.modifiers, false);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getAccessFlags() {
        return this.modifiers;
    }

    public String getTypeStr() {
        return this.typeStr;
    }

    public Object getConstFinalValue() {
        return this.constValue;
    }

    public List<String> getAnnotationNames() {
        return this.annotationNames;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.annotationNames.isEmpty()) {
            for (String annotationName : this.annotationNames) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append("@" + annotationName);
            }
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getModifiers());
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getTypeStr());
        buf.append(' ');
        buf.append(this.fieldName);
        if (this.constValue != null) {
            buf.append(" = ");
            if (this.constValue instanceof String) {
                buf.append("\"" + this.constValue + "\"");
            } else if (this.constValue instanceof Character) {
                buf.append("'" + this.constValue + "'");
            } else {
                buf.append(this.constValue.toString());
            }
        }
        return buf.toString();
    }
}

