/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FelixClassLoaderHandler
implements ClassLoaderHandler {
    private final String JAR_FILE_PREFIX = "jar:";
    private final String JAR_FILE_DELIM = "!/";
    private static final String BY_COMMA = ",";

    @Override
    public boolean handle(ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        List<ClassLoader> classLoaders = Arrays.asList(classLoader);
        for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5".equals(c.getName())) continue;
            Object m_wiring = ReflectionUtils.getFieldVal(classLoader, "m_wiring");
            Object bundle = ReflectionUtils.invokeMethod(m_wiring, "getBundle");
            Map bundleHeaders = (Map)ReflectionUtils.getFieldVal(bundle, "m_cachedHeaders");
            Object bundlefile = ReflectionUtils.getFieldVal(bundle, "m_archive");
            Object bundlefileLocation = ReflectionUtils.getFieldVal(bundlefile, "m_originalLocation");
            if (bundleHeaders == null || bundleHeaders.isEmpty()) continue;
            String bundleFile = (String)bundlefileLocation;
            classpathFinder.addClasspathElement(bundleFile, classLoaders, log);
            Iterator it = bundleHeaders.entrySet().iterator();
            if (it.hasNext()) {
                Map.Entry pair = it.next();
                Map stringMap = (Map)pair.getValue();
                String classpath = (String)stringMap.get("Bundle-Classpath");
                if (classpath != null) {
                    String[] splitJars = classpath.split(BY_COMMA);
                    for (int i = 0; i < splitJars.length; ++i) {
                        if (splitJars[i].isEmpty()) continue;
                        String jarPath = "jar:" + bundleFile + "!/" + splitJars[i];
                        classpathFinder.addClasspathElement(jarPath, classLoaders, log);
                    }
                } else {
                    classpathFinder.addClasspathElement(bundleFile.replace("reference:", "jar:"), classLoaders, log);
                }
            }
            return true;
        }
        return false;
    }
}

