/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import cn.easii.tutelary.deps.com.squareup.javapoet.AnnotationSpec;
import cn.easii.tutelary.deps.com.squareup.javapoet.ClassName;
import cn.easii.tutelary.deps.com.squareup.javapoet.CodeBlock;
import cn.easii.tutelary.deps.com.squareup.javapoet.JavaFile;
import cn.easii.tutelary.deps.com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.utils.CollectionUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class MapperConfigGenerator {
    public void write(ProcessingEnvironment processingEnv, String mapstructConfigName, String adapterClassName, List<TypeMirror> uses) {
        try (Writer writer = processingEnv.getFiler().createSourceFile(AutoMapperProperties.getConfigPackage() + "." + mapstructConfigName, new Element[0]).openWriter();){
            JavaFile.builder((String)AutoMapperProperties.getConfigPackage(), (TypeSpec)this.createConfigTypeSpec(mapstructConfigName, adapterClassName, uses)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + AutoMapperProperties.getConfigClassName() + " output file: " + e.getMessage());
        }
    }

    private TypeSpec createConfigTypeSpec(String mapstructConfigName, String adapterClassName, List<TypeMirror> uses) {
        return TypeSpec.interfaceBuilder((String)mapstructConfigName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildMapperConfigAnnotationSpec(adapterClassName, uses)).build();
    }

    private AnnotationSpec buildMapperConfigAnnotationSpec(String adapterClassName, List<TypeMirror> uses) {
        CodeBlock.Builder usesCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        usesCodeBuilder.add("$T.class", new Object[]{ClassName.get((String)AutoMapperProperties.getAdapterPackage(), (String)adapterClassName, (String[])new String[0])});
        if (CollectionUtils.isNotEmpty(uses)) {
            uses.forEach(use -> usesCodeBuilder.add(", $T.class", new Object[]{use}));
        }
        CodeBlock usesCodeBlock = usesCodeBuilder.add("}", new Object[0]).build();
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"MapperConfig", (String[])new String[0])).addMember("componentModel", CodeBlock.builder().add("$S", new Object[]{AutoMapperProperties.getComponentModel()}).build()).addMember("uses", usesCodeBlock);
        if (AutoMapperProperties.getUnmappedSourcePolicy() != null) {
            CodeBlock unmappedSourcePolicyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"ReportingPolicy", (String[])new String[0]), AutoMapperProperties.getUnmappedSourcePolicy()}).build();
            builder.addMember("unmappedSourcePolicy", unmappedSourcePolicyCodeBlock);
        }
        if (AutoMapperProperties.getUnmappedTargetPolicy() != null) {
            CodeBlock unmappedTargetPolicyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"ReportingPolicy", (String[])new String[0]), AutoMapperProperties.getUnmappedTargetPolicy()}).build();
            builder.addMember("unmappedTargetPolicy", unmappedTargetPolicyCodeBlock);
        }
        if (AutoMapperProperties.getTypeConversionPolicy() != null) {
            CodeBlock typeConversionCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"ReportingPolicy", (String[])new String[0]), AutoMapperProperties.getTypeConversionPolicy()}).build();
            builder.addMember("typeConversionPolicy", typeConversionCodeBlock);
        }
        if (AutoMapperProperties.getCollectionMappingStrategy() != null) {
            CodeBlock collectionMappingStrategyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"CollectionMappingStrategy", (String[])new String[0]), AutoMapperProperties.getCollectionMappingStrategy()}).build();
            builder.addMember("collectionMappingStrategy", collectionMappingStrategyCodeBlock);
        }
        if (AutoMapperProperties.getNullValueMappingStrategy() != null) {
            CodeBlock nullValueMappingStrategyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"NullValueMappingStrategy", (String[])new String[0]), AutoMapperProperties.getNullValueMappingStrategy()}).build();
            builder.addMember("nullValueMappingStrategy", nullValueMappingStrategyCodeBlock);
        }
        if (AutoMapperProperties.getNullValueIterableMappingStrategy() != null) {
            CodeBlock nullValueIterableMappingStrategyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"NullValueMappingStrategy", (String[])new String[0]), AutoMapperProperties.getNullValueIterableMappingStrategy()}).build();
            builder.addMember("nullValueIterableMappingStrategy", nullValueIterableMappingStrategyCodeBlock);
        }
        if (AutoMapperProperties.getNullValueMapMappingStrategy() != null) {
            CodeBlock nullValueMapMappingStrategyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"NullValueMappingStrategy", (String[])new String[0]), AutoMapperProperties.getNullValueMapMappingStrategy()}).build();
            builder.addMember("nullValueMapMappingStrategy", nullValueMapMappingStrategyCodeBlock);
        }
        if (AutoMapperProperties.getNullValuePropertyMappingStrategy() != null) {
            CodeBlock nullValuePropertyMappingStrategyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"NullValuePropertyMappingStrategy", (String[])new String[0]), AutoMapperProperties.getNullValuePropertyMappingStrategy()}).build();
            builder.addMember("nullValuePropertyMappingStrategy", nullValuePropertyMappingStrategyCodeBlock);
        }
        if (AutoMapperProperties.getNullValueCheckStrategy() != null) {
            CodeBlock nullValueCheckStrategyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"NullValueCheckStrategy", (String[])new String[0]), AutoMapperProperties.getNullValueCheckStrategy()}).build();
            builder.addMember("nullValueCheckStrategy", nullValueCheckStrategyCodeBlock);
        }
        if (AutoMapperProperties.getMappingControl() != null) {
            CodeBlock mappingControlCodeBlock = CodeBlock.builder().add("$T.class", new Object[]{AutoMapperProperties.getMappingControl()}).build();
            builder.addMember("mappingControl", mappingControlCodeBlock);
        }
        if (AutoMapperProperties.getUnexpectedValueMappingException() != null) {
            CodeBlock unexpectedValueMappingExceptionCodeBlock = CodeBlock.builder().add("$T.class", new Object[]{AutoMapperProperties.getUnexpectedValueMappingException()}).build();
            builder.addMember("unexpectedValueMappingException", unexpectedValueMappingExceptionCodeBlock);
        }
        if (AutoMapperProperties.getSuppressTimestampInGenerated() != null) {
            builder.addMember("suppressTimestampInGenerated", CodeBlock.builder().add(String.valueOf(AutoMapperProperties.getSuppressTimestampInGenerated()), new Object[0]).build());
        }
        CodeBlock builderCodeBlock = CodeBlock.builder().add("@$T(buildMethod = $S, disableBuilder = $L)", new Object[]{ClassName.get((String)"org.mapstruct", (String)"Builder", (String[])new String[0]), AutoMapperProperties.getBuildMethod(), AutoMapperProperties.isDisableBuilder()}).build();
        builder.addMember("builder", builderCodeBlock);
        return builder.build();
    }
}

