/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.utils;

import io.github.linpeilie.processor.utils.FileUtils;
import io.github.linpeilie.processor.utils.FileWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Collection;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileReader create(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public <T extends Collection<String>> T readLines(T collection) {
        T t;
        BufferedReader reader = null;
        try {
            String line;
            reader = FileUtils.getReader(this.file, this.charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
            t = collection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return t;
    }

    private void checkFile() {
        if (this.file == null) {
            throw new UncheckedIOException(new IOException("File to write content is null !"));
        }
        if (this.file.exists() && !this.file.isFile()) {
            throw new UncheckedIOException(new IOException("File [" + this.file.getAbsoluteFile() + "] is not a file !"));
        }
    }
}

