/*
 * Decompiled with CFR 0.152.
 */
package com.github.lazyboyl.shardingsphere.springboot.starter.util;

public class ShardingsphereUtil {
    public static String getShardingConfig(String cfg) {
        return ShardingsphereUtil.parseShardingConfig(ShardingsphereUtil.parseYamlConfig(cfg));
    }

    private static String parseShardingConfig(String shardingConfig) {
        StringBuilder sb = new StringBuilder();
        Integer subLength = ShardingsphereUtil.getSubSpaceLength(shardingConfig);
        String[] shardingConfigs = shardingConfig.split("\n");
        Integer level = 0;
        for (String s : shardingConfigs) {
            if (s.length() < subLength) continue;
            level = level + 1;
            if (ShardingsphereUtil.isInclude(s, "sharding:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("sharding:", "- !SHARDING"), subLength)).append("\n");
                continue;
            }
            if (ShardingsphereUtil.isInclude(s, "mask:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("mask:", "- !MASK"), subLength)).append("\n");
                continue;
            }
            if (ShardingsphereUtil.isInclude(s, "encrypt:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("encrypt:", "- !ENCRYPT"), subLength)).append("\n");
                continue;
            }
            if (ShardingsphereUtil.isInclude(s, "single:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("single:", "- !SINGLE"), subLength)).append("\n");
                continue;
            }
            if (ShardingsphereUtil.isInclude(s, "readwrite_splitting:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("readwrite_splitting:", "- !READWRITE_SPLITTING"), subLength)).append("\n");
                continue;
            }
            if (ShardingsphereUtil.isInclude(s, "broadcast:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("broadcast:", "- !BROADCAST"), subLength)).append("\n");
                continue;
            }
            if (ShardingsphereUtil.isInclude(s, "shadow:").booleanValue()) {
                sb.append(ShardingsphereUtil.subStr(s.replaceAll("shadow:", "- !SHADOW"), subLength)).append("\n");
                continue;
            }
            sb.append(ShardingsphereUtil.subStr(s, subLength)).append("\n");
        }
        return sb.toString();
    }

    private static String parseYamlConfig(String cfg) {
        StringBuilder sb = new StringBuilder();
        String[] cfgs = cfg.split("\n");
        boolean firstCheck = false;
        boolean secondCheck = false;
        Integer subLength = 0;
        for (String s : cfgs) {
            if (firstCheck && s.replaceAll("\n", "").indexOf("shardingsphere:") != -1) {
                secondCheck = true;
                subLength = s.split("shardingsphere:")[0].length();
                continue;
            }
            if (s.replaceAll("\n", "").equals("spring:")) {
                firstCheck = true;
                continue;
            }
            if (!secondCheck || s.trim().equals("") || s.trim().startsWith("#")) continue;
            if (s.matches("^\\s{" + subLength + "}[a-zA-Z0-9!@#$%^&*()\\-_=+{};:,<.>]+$")) break;
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    private static Integer getSubSpaceLength(String shardingConfig) {
        String[] shardingConfigs;
        Integer spaceLength = 0;
        for (String s : shardingConfigs = shardingConfig.split("\n")) {
            Integer length;
            if (s.replaceAll("\n", "").indexOf("dataSources:") == -1 || (length = Integer.valueOf(s.split("dataSources:")[0].length())) >= 8) continue;
            return s.split("dataSources:")[0].length();
        }
        return spaceLength;
    }

    private static String subStr(String s, Integer start) {
        if (s.length() > start) {
            String subStr = s.substring(start);
            if (s.trim().startsWith("#") && !subStr.trim().startsWith("#")) {
                return s;
            }
            return subStr;
        }
        return s;
    }

    private static Boolean isInclude(String str, String key) {
        return str.trim().equals(key);
    }
}

